/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.time.impl;

import java.util.Date;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.PseudoClockScheduler;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class PseudoClockSchedulerTest {
    private Job mockJob_1 = (Job)Mockito.mock(Job.class, (String)"mockJob_1");
    private JobContext mockContext_1 = (JobContext)Mockito.mock(JobContext.class, (String)"mockContext_1");
    private Trigger mockTrigger_1 = (Trigger)Mockito.mock(Trigger.class, (String)"mockTrigger_1");
    private Job mockJob_2 = (Job)Mockito.mock(Job.class, (String)"mockJob_2");
    private JobContext mockContext_2 = (JobContext)Mockito.mock(JobContext.class, (String)"mockContext_2");
    private Trigger mockTrigger_2 = (Trigger)Mockito.mock(Trigger.class, (String)"mockTrigger_2");
    private PseudoClockScheduler scheduler = new PseudoClockScheduler();

    @Test
    public void removeExistingJob() {
        Date triggerTime = new Date(1000L);
        Mockito.when((Object)this.mockTrigger_1.hasNextFireTime()).thenReturn((Object)triggerTime);
        JobHandle jobHandle = this.scheduler.scheduleJob(this.mockJob_1, this.mockContext_1, this.mockTrigger_1);
        Assert.assertThat((Object)this.scheduler.getTimeToNextJob(), (Matcher)Is.is((Object)triggerTime.getTime()));
        this.scheduler.removeJob(jobHandle);
        Assert.assertThat((Object)this.scheduler.getTimeToNextJob(), (Matcher)Is.is((Object)-1L));
        ((Trigger)Mockito.verify((Object)this.mockTrigger_1, (VerificationMode)Mockito.atLeastOnce())).hasNextFireTime();
    }

    @Test
    public void removeExistingJobWhenMultipleQueued() {
        Date triggerTime_1 = new Date(1000L);
        Date triggerTime_2 = new Date(2000L);
        Mockito.when((Object)this.mockTrigger_1.hasNextFireTime()).thenReturn((Object)triggerTime_1);
        Mockito.when((Object)this.mockTrigger_2.hasNextFireTime()).thenReturn((Object)triggerTime_2);
        JobHandle jobHandle_1 = this.scheduler.scheduleJob(this.mockJob_1, this.mockContext_1, this.mockTrigger_1);
        JobHandle jobHandle_2 = this.scheduler.scheduleJob(this.mockJob_2, this.mockContext_2, this.mockTrigger_2);
        Assert.assertThat((Object)this.scheduler.getTimeToNextJob(), (Matcher)Is.is((Object)triggerTime_1.getTime()));
        this.scheduler.removeJob(jobHandle_1);
        Assert.assertThat((Object)this.scheduler.getTimeToNextJob(), (Matcher)Is.is((Object)triggerTime_2.getTime()));
        this.scheduler.removeJob(jobHandle_2);
        Assert.assertThat((Object)this.scheduler.getTimeToNextJob(), (Matcher)Is.is((Object)-1L));
        ((Trigger)Mockito.verify((Object)this.mockTrigger_1, (VerificationMode)Mockito.atLeastOnce())).hasNextFireTime();
        ((Trigger)Mockito.verify((Object)this.mockTrigger_2, (VerificationMode)Mockito.atLeastOnce())).hasNextFireTime();
    }

    @Test
    public void timerIsSetToJobTriggerTimeForExecution() {
        Date triggerTime = new Date(1000L);
        Mockito.when((Object)this.mockTrigger_1.hasNextFireTime()).thenReturn((Object)triggerTime, (Object[])new Date[]{triggerTime, triggerTime, null});
        Mockito.when((Object)this.mockTrigger_1.nextFireTime()).thenReturn((Object)triggerTime);
        Mockito.when((Object)this.mockContext_1.getInternalKnowledgeRuntime()).thenReturn(Optional.empty());
        Job job = new Job(){

            public void execute(JobContext ctx) {
                Assert.assertThat((Object)PseudoClockSchedulerTest.this.scheduler.getCurrentTime(), (Matcher)Is.is((Object)1000L));
            }
        };
        this.scheduler.scheduleJob(job, this.mockContext_1, this.mockTrigger_1);
        this.scheduler.advanceTime(5000L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)this.scheduler.getCurrentTime(), (Matcher)Is.is((Object)5000L));
        ((Trigger)Mockito.verify((Object)this.mockTrigger_1, (VerificationMode)Mockito.atLeast((int)2))).hasNextFireTime();
        ((Trigger)Mockito.verify((Object)this.mockTrigger_1, (VerificationMode)Mockito.times((int)1))).nextFireTime();
    }

    @Test
    public void timerIsResetWhenJobThrowsExceptions() {
        Date triggerTime = new Date(1000L);
        Mockito.when((Object)this.mockTrigger_1.hasNextFireTime()).thenReturn((Object)triggerTime, (Object[])new Date[]{triggerTime, triggerTime, null});
        Mockito.when((Object)this.mockTrigger_1.nextFireTime()).thenReturn((Object)triggerTime);
        Mockito.when((Object)this.mockContext_1.getInternalKnowledgeRuntime()).thenReturn(Optional.empty());
        Job job = new Job(){

            public void execute(JobContext ctx) {
                Assert.assertThat((Object)PseudoClockSchedulerTest.this.scheduler.getCurrentTime(), (Matcher)Is.is((Object)1000L));
                throw new RuntimeException("for test");
            }
        };
        this.scheduler.scheduleJob(job, this.mockContext_1, this.mockTrigger_1);
        this.scheduler.advanceTime(5000L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)this.scheduler.getCurrentTime(), (Matcher)Is.is((Object)5000L));
        ((Trigger)Mockito.verify((Object)this.mockTrigger_1, (VerificationMode)Mockito.atLeast((int)2))).hasNextFireTime();
        ((Trigger)Mockito.verify((Object)this.mockTrigger_1, (VerificationMode)Mockito.times((int)1))).nextFireTime();
    }
}

