/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import org.drools.core.util.KeyStoreHelper;
import org.junit.Assert;
import org.junit.Test;

public class KeyStoreHelperTest {
    @Test
    public void testSignDataWithPrivateKey() throws UnsupportedEncodingException, UnrecoverableKeyException, InvalidKeyException, KeyStoreException, NoSuchAlgorithmException, SignatureException {
        URL serverKeyStoreURL = this.getClass().getResource("droolsServer.keystore");
        System.setProperty("drools.serialization.sign", "true");
        System.setProperty("drools.serialization.private.keyStoreURL", serverKeyStoreURL.toExternalForm());
        System.setProperty("drools.serialization.private.keyStorePwd", "serverpwd");
        System.setProperty("drools.serialization.private.keyAlias", "droolsKey");
        System.setProperty("drools.serialization.private.keyPwd", "keypwd");
        KeyStoreHelper serverHelper = new KeyStoreHelper();
        byte[] data = "Hello World".getBytes("UTF8");
        byte[] signature = serverHelper.signDataWithPrivateKey(data);
        URL clientKeyStoreURL = this.getClass().getResource("droolsClient.keystore");
        System.setProperty("drools.serialization.sign", "true");
        System.setProperty("drools.serialization.public.keyStoreURL", clientKeyStoreURL.toExternalForm());
        System.setProperty("drools.serialization.public.keyStorePwd", "clientpwd");
        KeyStoreHelper clientHelper = new KeyStoreHelper();
        Assert.assertTrue((boolean)clientHelper.checkDataWithPublicKey("droolsKey", data, signature));
        Assert.assertFalse((boolean)clientHelper.checkDataWithPublicKey("droolsKey", "fake".getBytes("UTF8"), signature));
    }

    @Test
    public void testLoadPassword() {
        KeyStoreHelper serverHelper = new KeyStoreHelper();
        try {
            serverHelper.getPasswordKey(null, null);
            Assert.fail();
        }
        catch (RuntimeException re) {
            Assert.assertTrue((boolean)true);
        }
        URL serverKeyStoreURL = this.getClass().getResource("droolsServer.jceks");
        System.setProperty("kie.keystore.keyStoreURL", serverKeyStoreURL.toExternalForm());
        System.setProperty("kie.keystore.keyStorePwd", "serverpwd");
        String PROP_PWD_ALIAS = "droolsKey";
        char[] PROP_PWD_PWD = "keypwd".toCharArray();
        try {
            serverHelper = new KeyStoreHelper();
            String passwordKey = serverHelper.getPasswordKey(PROP_PWD_ALIAS, PROP_PWD_PWD);
            Assert.assertEquals((Object)"passwd", (Object)passwordKey);
        }
        catch (RuntimeException re) {
            Assert.fail();
        }
    }
}

