/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import javax.management.MBeanServer;

public class HeapDump {
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static volatile Object hotspotMBean;

    public static void dumpHeap(String fileName, boolean live) {
        HeapDump.initHotspotMBean();
        try {
            Class<?> clazz = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            Method m = clazz.getMethod("dumpHeap", String.class, Boolean.TYPE);
            m.invoke(hotspotMBean, fileName, live);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initHotspotMBean() {
        if (hotspotMBean != null) return;
        Class<HeapDump> clazz = HeapDump.class;
        synchronized (HeapDump.class) {
            if (hotspotMBean != null) return;
            hotspotMBean = HeapDump.getHotspotMBean();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static Object getHotspotMBean() {
        try {
            Class<?> clazz = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            return ManagementFactory.newPlatformMXBeanProxy(server, HOTSPOT_BEAN_NAME, clazz);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }
}

