/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.bitmask;

import org.drools.core.util.bitmask.AllSetBitMask;
import org.drools.core.util.bitmask.AllSetButLastBitMask;
import org.drools.core.util.bitmask.BitMask;
import org.drools.core.util.bitmask.EmptyBitMask;
import org.drools.core.util.bitmask.EmptyButLastBitMask;
import org.drools.core.util.bitmask.LongBitMask;
import org.drools.core.util.bitmask.OpenBitSet;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class LongBitMaskTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Test
    public void testSet() {
        Assert.assertEquals((Object)"1", (Object)new LongBitMask().set(0).toString());
        Assert.assertEquals((Object)"2", (Object)new LongBitMask().set(1).toString());
        Assert.assertEquals((Object)"0, 2", (Object)new LongBitMask().set(65).toString());
    }

    @Test
    public void testSetAll() {
        Assert.assertEquals((Object)"0", (Object)new LongBitMask().setAll((BitMask)new LongBitMask()).toString());
        Assert.assertEquals((Object)"-1", (Object)new LongBitMask().setAll((BitMask)AllSetBitMask.get()).toString());
        Assert.assertEquals((Object)"9223372036854775807", (Object)new LongBitMask().setAll((BitMask)AllSetButLastBitMask.get()).toString());
        Assert.assertEquals((Object)"-1", (Object)new LongBitMask(1L).setAll((BitMask)AllSetButLastBitMask.get()).toString());
        Assert.assertEquals((Object)"0", (Object)new LongBitMask().setAll((BitMask)new OpenBitSet()).toString());
        Assert.assertEquals((Object)"1", (Object)new LongBitMask().setAll((BitMask)EmptyButLastBitMask.get()).toString());
        Assert.assertEquals((Object)"0", (Object)new LongBitMask().setAll((BitMask)EmptyBitMask.get()).toString());
    }

    @Test
    public void testReset() {
        Assert.assertEquals((Object)"0", (Object)new LongBitMask().reset(0).toString());
        Assert.assertEquals((Object)"0", (Object)new LongBitMask().reset(1).toString());
        Assert.assertEquals((Object)"0", (Object)new LongBitMask().reset(65).toString());
    }

    @Test
    public void testResetAll() {
        Assert.assertEquals((Object)"0", (Object)new LongBitMask().resetAll((BitMask)new LongBitMask()).toString());
        Assert.assertEquals((Object)"0", (Object)new LongBitMask().resetAll((BitMask)AllSetBitMask.get()).toString());
        Assert.assertEquals((Object)"0", (Object)new LongBitMask().resetAll((BitMask)AllSetButLastBitMask.get()).toString());
        Assert.assertEquals((Object)"0", (Object)new LongBitMask().resetAll((BitMask)EmptyButLastBitMask.get()).toString());
        Assert.assertEquals((Object)"0", (Object)new LongBitMask().resetAll((BitMask)EmptyBitMask.get()).toString());
        this.thrown.expect(RuntimeException.class);
        new LongBitMask().resetAll((BitMask)new OpenBitSet()).toString();
    }

    @Test
    public void testIsSet() {
        Assert.assertFalse((boolean)new LongBitMask().set(1).isSet(0));
        Assert.assertTrue((boolean)new LongBitMask().set(1).isSet(1));
    }

    @Test
    public void testIsAllSet() {
        Assert.assertFalse((boolean)new LongBitMask().isAllSet());
        Assert.assertTrue((boolean)new LongBitMask(-1L).isAllSet());
    }

    @Test
    public void testIsEmpty() {
        Assert.assertFalse((boolean)new LongBitMask(1L).isEmpty());
        Assert.assertTrue((boolean)new LongBitMask(0L).isEmpty());
    }

    @Test
    public void testIntersects() {
        Assert.assertFalse((boolean)new LongBitMask(0L).intersects((BitMask)EmptyBitMask.get()));
        Assert.assertFalse((boolean)new LongBitMask(0L).intersects((BitMask)new LongBitMask(0L)));
        Assert.assertTrue((boolean)new LongBitMask(2L).intersects((BitMask)new LongBitMask(2L)));
    }

    @Test
    public void testClone() {
        Assert.assertEquals((long)1L, (long)new LongBitMask(1L).clone().asLong());
    }

    @Test
    public void testGetInstancingStatement() {
        Assert.assertEquals((Object)"org.drools.core.util.bitmask.EmptyBitMask.get()", (Object)new LongBitMask(0L).getInstancingStatement());
        Assert.assertEquals((Object)"org.drools.core.util.bitmask.EmptyButLastBitMask.get()", (Object)new LongBitMask(1L).getInstancingStatement());
        Assert.assertEquals((Object)"org.drools.core.util.bitmask.AllSetButLastBitMask.get()", (Object)new LongBitMask(Long.MAX_VALUE).getInstancingStatement());
        Assert.assertEquals((Object)"org.drools.core.util.bitmask.AllSetBitMask.get()", (Object)new LongBitMask(-1L).getInstancingStatement());
        Assert.assertEquals((Object)"new org.drools.core.util.bitmask.LongBitMask(2L)", (Object)new LongBitMask(2L).getInstancingStatement());
    }
}

