/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.time.impl;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.junit.Test;

public abstract class SerializationTestSupport {
    protected abstract Object getTargetObject() throws Exception;

    protected abstract String[] getVersions();

    protected abstract void verifyMatch(Object var1, Object var2);

    @Test
    public void testSerialization() throws Exception {
        Object targetObject = this.getTargetObject();
        for (int i = 0; i < this.getVersions().length; ++i) {
            String version = this.getVersions()[i];
            this.verifyMatch(targetObject, this.deserialize(version, targetObject.getClass()));
        }
    }

    protected Object deserialize(String version, Class clazz) throws Exception {
        InputStream is = this.getClass().getResourceAsStream(this.getSerializedFileName(version, clazz));
        ObjectInputStream ois = new ObjectInputStream(is);
        Object obj = ois.readObject();
        ois.close();
        is.close();
        return obj;
    }

    public void writeJobDataFile(String version) throws Exception {
        Object obj = this.getTargetObject();
        FileOutputStream fos = new FileOutputStream(this.getSerializedFileName(version, obj.getClass()));
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(obj);
        oos.flush();
        fos.close();
        oos.close();
    }

    private String getSerializedFileName(String version, Class clazz) {
        String className = clazz.getName();
        int index = className.lastIndexOf(".");
        index = index < 0 ? 0 : index + 1;
        return className.substring(index) + "-" + version + ".ser";
    }
}

