/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.util.Random;
import org.drools.core.util.Entry;
import org.drools.core.util.FastIterator;
import org.drools.core.util.TupleRBTree;
import org.junit.Assert;
import org.junit.Test;

public class LeftTupleRBTreeTest {
    @Test
    public void testIterator() {
        int i;
        int ITEMS = 10000;
        TupleRBTree tree = new TupleRBTree();
        Random random = new Random(0L);
        for (i = 0; i < 10000; ++i) {
            int key = random.nextInt();
            tree.insert((Comparable)Integer.valueOf(key));
        }
        i = 0;
        FastIterator fastIterator = tree.fastIterator();
        int lastKey = Integer.MIN_VALUE;
        TupleRBTree.Node node = (TupleRBTree.Node)fastIterator.next(null);
        while (node != null) {
            int currentKey = (Integer)node.key;
            if (currentKey < lastKey) {
                Assert.fail((String)(currentKey + " should be greater than " + lastKey));
            }
            lastKey = currentKey;
            ++i;
            node = (TupleRBTree.Node)fastIterator.next((Entry)node);
        }
        Assert.assertEquals((long)10000L, (long)i);
    }

    @Test
    public void testRange() {
        TupleRBTree tree = new TupleRBTree();
        tree.insert((Comparable)Integer.valueOf(10));
        tree.insert((Comparable)Integer.valueOf(20));
        tree.insert((Comparable)Integer.valueOf(25));
        tree.insert((Comparable)Integer.valueOf(15));
        tree.insert((Comparable)Integer.valueOf(5));
        FastIterator fastIterator = tree.range((Comparable)Integer.valueOf(2), true, (Comparable)Integer.valueOf(15), false);
        TupleRBTree.Node node = (TupleRBTree.Node)fastIterator.next(null);
        Assert.assertEquals((long)5L, (long)((Integer)node.key).intValue());
        node = (TupleRBTree.Node)fastIterator.next((Entry)node);
        Assert.assertEquals((long)10L, (long)((Integer)node.key).intValue());
        node = (TupleRBTree.Node)fastIterator.next((Entry)node);
        Assert.assertNull((Object)node);
        fastIterator = tree.range((Comparable)Integer.valueOf(2), true, (Comparable)Integer.valueOf(5), false);
        node = (TupleRBTree.Node)fastIterator.next(null);
        Assert.assertNull((Object)node);
        fastIterator = tree.range((Comparable)Integer.valueOf(25), false, (Comparable)Integer.valueOf(35), true);
        node = (TupleRBTree.Node)fastIterator.next(null);
        Assert.assertNull((Object)node);
        fastIterator = tree.range((Comparable)Integer.valueOf(6), false, (Comparable)Integer.valueOf(9), false);
        node = (TupleRBTree.Node)fastIterator.next(null);
        Assert.assertNull((Object)node);
        fastIterator = tree.range((Comparable)Integer.valueOf(5), false, (Comparable)Integer.valueOf(35), false);
        node = (TupleRBTree.Node)fastIterator.next(null);
        Assert.assertEquals((long)10L, (long)((Integer)node.key).intValue());
        node = (TupleRBTree.Node)fastIterator.next((Entry)node);
        Assert.assertEquals((long)15L, (long)((Integer)node.key).intValue());
        node = (TupleRBTree.Node)fastIterator.next((Entry)node);
        Assert.assertEquals((long)20L, (long)((Integer)node.key).intValue());
        node = (TupleRBTree.Node)fastIterator.next((Entry)node);
        Assert.assertEquals((long)25L, (long)((Integer)node.key).intValue());
        node = (TupleRBTree.Node)fastIterator.next((Entry)node);
        Assert.assertNull((Object)node);
    }
}

