/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.drools.core.WorkingMemory;
import org.drools.core.base.ClassObjectType;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.spi.Consequence;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.spi.ObjectType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.definition.KiePackage;
import org.kie.api.runtime.KieSession;

public class CrossProductTest {
    private InternalKnowledgePackage pkg;
    private KieSession ksession;
    private List values;

    @Before
    public void setUp() throws Exception {
        ClassObjectType list1ObjectType = new ClassObjectType(String.class);
        ClassObjectType list2ObjectType = new ClassObjectType(String.class);
        RuleImpl rule = new RuleImpl("rule-1");
        Pattern list1Pattern = new Pattern(0, (ObjectType)list1ObjectType, "s1");
        Pattern list2Pattern = new Pattern(1, (ObjectType)list2ObjectType, "s2");
        rule.addPattern((RuleConditionElement)list1Pattern);
        rule.addPattern((RuleConditionElement)list2Pattern);
        final Declaration s1Declaration = rule.getDeclaration("s1");
        final Declaration s2Declaration = rule.getDeclaration("s2");
        this.values = new ArrayList();
        rule.setConsequence(new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) throws Exception {
                String s1 = (String)knowledgeHelper.get(s1Declaration);
                String s2 = (String)knowledgeHelper.get(s2Declaration);
                CrossProductTest.this.values.add(new String[]{s1, s2});
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        });
        this.pkg = new KnowledgePackageImpl("org.drools");
        this.pkg.addRule(rule);
    }

    @Test
    public void testNotRemoveIdentities() throws Exception {
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        kBase.addPackage((KiePackage)this.pkg);
        this.ksession = kBase.newKieSession();
        this.ksession.insert((Object)"F1");
        this.ksession.insert((Object)"F2");
        this.ksession.insert((Object)"F3");
        this.ksession.insert((Object)"F4");
        this.ksession.fireAllRules();
        System.out.println(this.values);
        Assert.assertEquals((long)16L, (long)this.values.size());
    }

    @Test
    public void testRemoveIdentities() throws Exception {
        System.setProperty("drools.removeIdentities", "true");
        try {
            InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
            kBase.addPackage((KiePackage)this.pkg);
            this.ksession = kBase.newKieSession();
            this.ksession.insert((Object)"F1");
            this.ksession.insert((Object)"F2");
            this.ksession.insert((Object)"F3");
            this.ksession.insert((Object)"F4");
            this.ksession.fireAllRules();
            Assert.assertEquals((long)12L, (long)this.values.size());
        }
        finally {
            System.setProperty("drools.removeIdentities", "false");
        }
    }
}

