/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.runtime.help.impl;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.drools.core.command.runtime.rule.AgendaGroupSetFocusCommand;
import org.drools.core.command.runtime.rule.ClearActivationGroupCommand;
import org.drools.core.command.runtime.rule.ClearAgendaCommand;
import org.drools.core.command.runtime.rule.ClearAgendaGroupCommand;
import org.drools.core.command.runtime.rule.ClearRuleFlowGroupCommand;
import org.drools.core.command.runtime.rule.DeleteCommand;
import org.drools.core.command.runtime.rule.GetFactHandlesCommand;
import org.drools.core.command.runtime.rule.ModifyCommand;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.runtime.help.impl.XStreamXML;
import org.drools.core.runtime.impl.ExecutionResultImpl;
import org.drools.core.runtime.rule.impl.FlatQueryResults;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.command.Setter;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.soup.xstream.XStreamUtils;

public class XStreamXMLTest {
    private XStream xstream;

    @Before
    public void setup() {
        this.xstream = XStreamUtils.createNonTrustingXStream();
        this.xstream = XStreamXML.newXStreamMarshaller((XStream)this.xstream);
    }

    @Test
    public void testMarshallStartProcessCmd() {
        StartProcessCommand cmd = new StartProcessCommand("some-process-id", "some-out-identifier");
        String xmlString = this.xstream.toXML((Object)cmd);
        Assert.assertTrue((boolean)xmlString.contains("processId=\"some-process-id\""));
        Assert.assertTrue((boolean)xmlString.contains("out-identifier=\"some-out-identifier\""));
    }

    @Test
    public void testMarshallStartProcessCmdWithNoOutIdentifier() {
        StartProcessCommand cmd = new StartProcessCommand("some-process-id");
        String xmlString = this.xstream.toXML((Object)cmd);
        Assert.assertTrue((boolean)xmlString.contains("processId=\"some-process-id\""));
    }

    @Test
    public void testUnMarshallStartProcessCmdWithNoOutIdentifier() {
        Object obj = this.xstream.fromXML("<start-process processId=\"some-process-id\"/>");
        Assert.assertEquals(StartProcessCommand.class, obj.getClass());
        StartProcessCommand cmd = (StartProcessCommand)obj;
        Assert.assertEquals((Object)"some-process-id", (Object)cmd.getProcessId());
    }

    @Test
    public void testMarshallAgendaGroupSetFocusCommand() {
        AgendaGroupSetFocusCommand cmd = new AgendaGroupSetFocusCommand("foo-group");
        String xmlString = this.xstream.toXML((Object)cmd);
        Assert.assertEquals((Object)"<set-focus name=\"foo-group\"/>", (Object)xmlString);
        AgendaGroupSetFocusCommand cmd2 = (AgendaGroupSetFocusCommand)this.xstream.fromXML(xmlString);
        Assert.assertEquals((Object)cmd.getName(), (Object)cmd2.getName());
    }

    @Test
    public void testClearActivationGroupCommand() {
        ClearActivationGroupCommand cmd = new ClearActivationGroupCommand("foo-group");
        String xmlString = this.xstream.toXML((Object)cmd);
        Assert.assertEquals((Object)"<clear-activation-group name=\"foo-group\"/>", (Object)xmlString);
        ClearActivationGroupCommand cmd2 = (ClearActivationGroupCommand)this.xstream.fromXML(xmlString);
        Assert.assertEquals((Object)cmd.getName(), (Object)cmd2.getName());
    }

    @Test
    public void testClearAgendaGroupCommand() {
        ClearAgendaGroupCommand cmd = new ClearAgendaGroupCommand("foo-group");
        String xmlString = this.xstream.toXML((Object)cmd);
        Assert.assertEquals((Object)"<clear-agenda-group name=\"foo-group\"/>", (Object)xmlString);
        ClearAgendaGroupCommand cmd2 = (ClearAgendaGroupCommand)this.xstream.fromXML(xmlString);
        Assert.assertEquals((Object)cmd.getName(), (Object)cmd2.getName());
    }

    @Test
    public void testClearAgendaCommand() {
        ClearAgendaCommand cmd = new ClearAgendaCommand();
        String xmlString = this.xstream.toXML((Object)cmd);
        Assert.assertEquals((Object)"<clear-agenda/>", (Object)xmlString);
        ClearAgendaCommand cmd2 = (ClearAgendaCommand)this.xstream.fromXML(xmlString);
    }

    @Test
    public void testClearRuleFlowGroupCommand() {
        ClearRuleFlowGroupCommand cmd = new ClearRuleFlowGroupCommand("foo-group");
        String xmlString = this.xstream.toXML((Object)cmd);
        Assert.assertEquals((Object)"<clear-ruleflow-group name=\"foo-group\"/>", (Object)xmlString);
        ClearRuleFlowGroupCommand cmd2 = (ClearRuleFlowGroupCommand)this.xstream.fromXML(xmlString);
        Assert.assertEquals((Object)cmd.getName(), (Object)cmd2.getName());
    }

    @Test
    public void testModifyCommand() {
        DefaultFactHandle factHandle = DefaultFactHandle.createFromExternalFormat((String)"0:1:10:10:20:null:NON_TRAIT:null");
        ModifyCommand cmd = new ModifyCommand((FactHandle)factHandle, Arrays.asList(new ModifyCommand.SetterImpl("name", "value")));
        String xmlString = this.xstream.toXML((Object)cmd);
        Assert.assertEquals((Object)"<modify fact-handle=\"0:1:10:10:20:null:NON_TRAIT:null\">\n  <set accessor=\"name\" value=\"value\"/>\n</modify>", (Object)xmlString);
        ModifyCommand cmd2 = (ModifyCommand)this.xstream.fromXML(xmlString);
        Assert.assertEquals((Object)factHandle.toExternalForm(), (Object)cmd2.getFactHandle().toExternalForm());
        Assert.assertEquals((long)1L, (long)cmd2.getSetters().size());
        Assert.assertEquals((Object)"name", (Object)((Setter)cmd2.getSetters().get(0)).getAccessor());
        Assert.assertEquals((Object)"value", (Object)((Setter)cmd2.getSetters().get(0)).getValue());
    }

    @Test
    public void testDeleteCommand() {
        DefaultFactHandle factHandle = DefaultFactHandle.createFromExternalFormat((String)"0:1:10:10:20:null:NON_TRAIT:null");
        DeleteCommand cmd = new DeleteCommand((FactHandle)factHandle);
        String xmlString = this.xstream.toXML((Object)cmd);
        Assert.assertEquals((Object)"<delete fact-handle=\"0:1:10:10:20:null:NON_TRAIT:null\"/>", (Object)xmlString);
        DeleteCommand cmd2 = (DeleteCommand)this.xstream.fromXML(xmlString);
        Assert.assertEquals((Object)factHandle.toExternalForm(), (Object)cmd2.getFactHandle().toExternalForm());
    }

    @Test
    public void testGetFactHandlesCommand() {
        GetFactHandlesCommand cmd = new GetFactHandlesCommand();
        String xmlString = this.xstream.toXML((Object)cmd);
        Assert.assertEquals((Object)"<get-fact-handles disconnected=\"false\"/>", (Object)xmlString);
        GetFactHandlesCommand cmd2 = (GetFactHandlesCommand)this.xstream.fromXML(xmlString);
        Assert.assertNull((Object)cmd2.getOutIdentifier());
    }

    @Test
    public void testGetFactHandlesCommandWithOutIdentifier() {
        GetFactHandlesCommand cmd = new GetFactHandlesCommand();
        cmd.setOutIdentifier("facts");
        String xmlString = this.xstream.toXML((Object)cmd);
        Assert.assertEquals((Object)"<get-fact-handles disconnected=\"false\" out-identifier=\"facts\"/>", (Object)xmlString);
        GetFactHandlesCommand cmd2 = (GetFactHandlesCommand)this.xstream.fromXML(xmlString);
        Assert.assertEquals((Object)"facts", (Object)cmd2.getOutIdentifier());
    }

    @Test
    public void testExecutionResults() {
        Message msg = new Message("Hello World!");
        DefaultFactHandle msgHandle = new DefaultFactHandle(1L, null, 10, 10, 20L, (Object)msg);
        Message msg2 = new Message("Hello World again!");
        DefaultFactHandle msgHandle2 = new DefaultFactHandle(2L, null, 10, 10, 20L, (Object)msg2);
        LinkedHashMap<String, DefaultFactHandle> factHandles = new LinkedHashMap<String, DefaultFactHandle>();
        factHandles.put("first", msgHandle);
        factHandles.put("second", msgHandle2);
        ExecutionResultImpl executionResult = new ExecutionResultImpl();
        executionResult.setFactHandles(factHandles);
        LinkedHashMap<String, Message> results = new LinkedHashMap<String, Message>();
        results.put("message1", msg);
        results.put("message2", msg2);
        executionResult.setResults(results);
        String xmlString = this.xstream.toXML((Object)executionResult);
        Assert.assertEquals((Object)"<execution-results>\n  <result identifier=\"message1\">\n    <org.drools.core.runtime.help.impl.XStreamXMLTest_-Message>\n      <msg>Hello World!</msg>\n    </org.drools.core.runtime.help.impl.XStreamXMLTest_-Message>\n  </result>\n  <result identifier=\"message2\">\n    <org.drools.core.runtime.help.impl.XStreamXMLTest_-Message>\n      <msg>Hello World again!</msg>\n    </org.drools.core.runtime.help.impl.XStreamXMLTest_-Message>\n  </result>\n  <fact-handle identifier=\"first\" external-form=\"0:1:10:10:20:null:NON_TRAIT:org.drools.core.runtime.help.impl.XStreamXMLTest$Message\"/>\n  <fact-handle identifier=\"second\" external-form=\"0:2:10:10:20:null:NON_TRAIT:org.drools.core.runtime.help.impl.XStreamXMLTest$Message\"/>\n</execution-results>", (Object)xmlString);
        ExecutionResultImpl executionResult2 = (ExecutionResultImpl)this.xstream.fromXML(xmlString);
        Assert.assertEquals((long)executionResult.getFactHandles().size(), (long)executionResult2.getFactHandles().size());
        Assert.assertEquals((long)executionResult.getResults().size(), (long)executionResult2.getResults().size());
    }

    @Test
    public void testGetFactHandlesExecutionResults() {
        Message msg = new Message("Hello World!");
        DefaultFactHandle msgHandle = new DefaultFactHandle(1L, null, 10, 10, 20L, (Object)msg);
        Message msg2 = new Message("Hello World again!");
        DefaultFactHandle msgHandle2 = new DefaultFactHandle(2L, null, 10, 10, 20L, (Object)msg2);
        ArrayList<DefaultFactHandle> factHandleList = new ArrayList<DefaultFactHandle>();
        factHandleList.add(msgHandle);
        factHandleList.add(msgHandle2);
        LinkedHashMap factHandles = new LinkedHashMap();
        ExecutionResultImpl executionResult = new ExecutionResultImpl();
        executionResult.setFactHandles(factHandles);
        LinkedHashMap<String, ArrayList<DefaultFactHandle>> results = new LinkedHashMap<String, ArrayList<DefaultFactHandle>>();
        results.put("facts", factHandleList);
        executionResult.setResults(results);
        String xmlString = this.xstream.toXML((Object)executionResult);
        Assert.assertEquals((Object)"<execution-results>\n  <result identifier=\"facts\">\n    <list>\n      <fact-handle external-form=\"0:1:10:10:20:null:NON_TRAIT:org.drools.core.runtime.help.impl.XStreamXMLTest$Message\"/>\n      <fact-handle external-form=\"0:2:10:10:20:null:NON_TRAIT:org.drools.core.runtime.help.impl.XStreamXMLTest$Message\"/>\n    </list>\n  </result>\n</execution-results>", (Object)xmlString);
        ExecutionResultImpl executionResult2 = (ExecutionResultImpl)this.xstream.fromXML(xmlString);
        Assert.assertEquals((long)executionResult.getFactHandles().size(), (long)executionResult2.getFactHandles().size());
        Assert.assertEquals((long)executionResult.getResults().size(), (long)executionResult2.getResults().size());
    }

    @Test
    public void testQueryResultsConverter() {
        final Message msg = new Message("Hello World!");
        DefaultFactHandle msgHandle = new DefaultFactHandle(1L, null, 10, 10, 20L, (Object)msg);
        HashSet<String> identifiers = new HashSet<String>(){
            {
                this.add("greeting");
            }
        };
        ArrayList<Map<String, FactHandle>> idFactHandleMaps = new ArrayList<Map<String, FactHandle>>((FactHandle)msgHandle){
            final /* synthetic */ FactHandle val$msgHandle;
            {
                this.val$msgHandle = factHandle;
                this.add(new HashMap<String, FactHandle>(){
                    {
                        this.put("greeting", val$msgHandle);
                    }
                });
            }
        };
        ArrayList<Map<String, Object>> factHandleResultMap = new ArrayList<Map<String, Object>>(){
            {
                this.add(new HashMap<String, Object>(){
                    {
                        this.put("greeting", msg);
                    }
                });
            }
        };
        String EXPECTED_XML = "<query-results>\n  <identifiers>\n    <identifier>greeting</identifier>\n  </identifiers>\n  <row>\n    <identifier id=\"greeting\">\n      <org.drools.core.runtime.help.impl.XStreamXMLTest_-Message>\n        <msg>Hello World!</msg>\n      </org.drools.core.runtime.help.impl.XStreamXMLTest_-Message>\n      <fact-handle external-form=\"0:1:10:10:20:null:NON_TRAIT:org.drools.core.runtime.help.impl.XStreamXMLTest$Message\"/>\n    </identifier>\n  </row>\n</query-results>";
        FlatQueryResults results = new FlatQueryResults((Set)identifiers, (ArrayList)idFactHandleMaps, (ArrayList)factHandleResultMap);
        String xmlString = this.xstream.toXML((Object)results);
        Assert.assertEquals((Object)"<query-results>\n  <identifiers>\n    <identifier>greeting</identifier>\n  </identifiers>\n  <row>\n    <identifier id=\"greeting\">\n      <org.drools.core.runtime.help.impl.XStreamXMLTest_-Message>\n        <msg>Hello World!</msg>\n      </org.drools.core.runtime.help.impl.XStreamXMLTest_-Message>\n      <fact-handle external-form=\"0:1:10:10:20:null:NON_TRAIT:org.drools.core.runtime.help.impl.XStreamXMLTest$Message\"/>\n    </identifier>\n  </row>\n</query-results>", (Object)xmlString);
        QueryResults results2 = (QueryResults)this.xstream.fromXML(xmlString);
        Assert.assertEquals((Object)results, (Object)results2);
    }

    private static class Message {
        String msg;

        public Message() {
        }

        public Message(String msg) {
            this.msg = msg;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Message)) {
                return false;
            }
            Message message = (Message)o;
            return !(this.msg == null ? message.msg != null : !this.msg.equals(message.msg));
        }

        public int hashCode() {
            return this.msg != null ? this.msg.hashCode() : 0;
        }
    }
}

