/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import org.drools.core.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.builder.ReleaseId;

public class StringUtilsTest {
    @Test
    public void testFindEndOfMethodArgsIndex() {
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId(\"myId\")", 12);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId(\"myId\").call()", 12);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId('myId')", 12);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId('myId').call()", 12);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId(\"my'Id\")", 13);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId(\"my'Id\").call()", 13);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId(\"my'Id'\")", 14);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId(\"my'Id'\").call()", 14);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId('my\"Id\"')", 14);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId('my\"Id\"').call()", 14);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId('my\"Id')", 13);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId('my\"Id').call()", 13);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId(\"my\\\"Id\")", 14);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId(\"my\\\"Id\").call()", 14);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId('myId', 'something')", 25);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId(\"myId\", \"something\")", 25);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId(\"my'Id\", \"somet'hing\")", 27);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId(\"my'Id'\", \"somet'hing\")", 28);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId(\"my'(Id\", \"somet'(hing'\")", 30);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setObject(new Object())", 22);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setObject(new Object(\"string param\"))", 36);
    }

    private void findEndOfMethodArgsIndexAndAssertItEqualsToExpected(String strExpr, int expectedIndex) {
        int actualIndex = StringUtils.findEndOfMethodArgsIndex((CharSequence)strExpr, (int)strExpr.indexOf(40));
        Assert.assertEquals((String)("Expected and actual end of method args index for expr '" + strExpr + "' are not equal!"), (long)expectedIndex, (long)actualIndex);
    }

    @Test
    public void test_codeAwareEqualsIgnoreSpaces() {
        Assert.assertTrue((boolean)StringUtils.codeAwareEqualsIgnoreSpaces(null, null));
        Assert.assertTrue((boolean)StringUtils.codeAwareEqualsIgnoreSpaces((String)"", (String)""));
        Assert.assertFalse((boolean)StringUtils.codeAwareEqualsIgnoreSpaces((String)"", null));
        Assert.assertFalse((boolean)StringUtils.codeAwareEqualsIgnoreSpaces(null, (String)""));
        Assert.assertTrue((boolean)StringUtils.codeAwareEqualsIgnoreSpaces((String)" ", (String)""));
        Assert.assertTrue((boolean)StringUtils.codeAwareEqualsIgnoreSpaces((String)"", (String)" "));
        Assert.assertTrue((boolean)StringUtils.codeAwareEqualsIgnoreSpaces((String)" ", (String)"  "));
        Assert.assertTrue((boolean)StringUtils.codeAwareEqualsIgnoreSpaces((String)"rule Rx when then end", (String)" rule Rx  when then end "));
        Assert.assertTrue((boolean)StringUtils.codeAwareEqualsIgnoreSpaces((String)"rule Rx when then end\n", (String)" rule Rx  when then end\n "));
        Assert.assertFalse((boolean)StringUtils.codeAwareEqualsIgnoreSpaces((String)"package org.drools.compiler\n", (String)"package org.drools.compiler\n rule Rx when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n"));
        Assert.assertTrue((boolean)StringUtils.codeAwareEqualsIgnoreSpaces((String)"package org.drools.compiler\nrule Rx when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n", (String)"package org.drools.compiler\n rule Rx when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n"));
        Assert.assertTrue((boolean)StringUtils.codeAwareEqualsIgnoreSpaces((String)"package org.drools.compiler\nrule Rx when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n", (String)" package org.drools.compiler\nrule Rx when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n"));
        Assert.assertTrue((boolean)StringUtils.codeAwareEqualsIgnoreSpaces((String)"package org.drools.compiler\nrule Rx when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n", (String)" package org.drools.compiler\n rule Rx when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n "));
        Assert.assertTrue((boolean)StringUtils.codeAwareEqualsIgnoreSpaces((String)"package org.drools.compiler\nrule Rx when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n", (String)"package org.drools.compiler\nrule Rx when\n   $m : Message( message == \"Hello World\"  )\nthen\nend\n"));
        Assert.assertFalse((boolean)StringUtils.codeAwareEqualsIgnoreSpaces((String)"package org.drools.compiler\nrule Rx when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n", (String)"package org.drools.compiler\nrule Rx when\n   $m : Message( message == \"Hello    World\" )\nthen\nend\n"));
        Assert.assertFalse((boolean)StringUtils.codeAwareEqualsIgnoreSpaces((String)"package org.drools.compiler\nrule Rx when\n   $m : Message( message == \"Hello' World\" )\nthen\nend\n", (String)"package org.drools.compiler\nrule Rx when\n   $m : Message( message == \"Hello'    World\" )\nthen\nend\n"));
        Assert.assertFalse((boolean)StringUtils.codeAwareEqualsIgnoreSpaces((String)"package org.drools.compiler\nrule Rx when\n   $m : Message( message == 'Hello World' )\nthen\nend\n", (String)"package org.drools.compiler\nrule Rx when\n   $m : Message( message == 'Hello    World' )\nthen\nend\n"));
        Assert.assertFalse((boolean)StringUtils.codeAwareEqualsIgnoreSpaces((String)"package org.drools.compiler\nrule Rx when\n   $m : Message( message == 'Hello\" World' )\nthen\nend\n", (String)"package org.drools.compiler\nrule Rx when\n   $m : Message( message == 'Hello\"    World' )\nthen\nend\n"));
        Assert.assertFalse((boolean)StringUtils.codeAwareEqualsIgnoreSpaces((String)"package org.drools.compiler\nrule Rx when\n   $m : Message( message == 'Hello\\' World' )\nthen\nend\n", (String)"package org.drools.compiler\nrule Rx when\n   $m : Message( message == 'Hello\\'    World' )\nthen\nend\n"));
    }

    @Test
    public void test_indexOfOutOfQuotes() {
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfOutOfQuotes((String)"bla\"bla\"bla", (String)"bla"));
        Assert.assertEquals((long)5L, (long)StringUtils.indexOfOutOfQuotes((String)"\"bla\"bla", (String)"bla"));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfOutOfQuotes((String)"\"bla\"", (String)"bla"));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfOutOfQuotes((String)"bla\"bla\"bla", (String)"bla", (int)0));
        Assert.assertEquals((long)8L, (long)StringUtils.indexOfOutOfQuotes((String)"bla\"bla\"bla", (String)"bla", (int)1));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfOutOfQuotes((String)"bla\"bla\"bla", (String)"bla", (int)9));
    }

    @Test
    public void getPkgUUIDFromReleaseIdNotNullNotSnapshot() {
        TestingReleaseId releaseId = new TestingReleaseId(false);
        String packageName = "apackage";
        String retrieved = StringUtils.getPkgUUID((ReleaseId)releaseId, (String)packageName);
        String expected = StringUtils.md5Hash((String)(releaseId.toString() + packageName));
        Assert.assertEquals((Object)expected, (Object)retrieved);
    }

    @Test
    public void getPkgUUIDFromReleaseIdNotNullSnapshot() {
        TestingReleaseId releaseId = new TestingReleaseId(true);
        String packageName = "apackage";
        String retrieved = StringUtils.getPkgUUID((ReleaseId)releaseId, (String)packageName);
        String unexpected = StringUtils.md5Hash((String)(releaseId.toString() + packageName));
        Assert.assertNotEquals((Object)unexpected, (Object)retrieved);
    }

    @Test
    public void getPkgUUIDFromReleaseIdNull() {
        ReleaseId releaseId = null;
        String packageName = "apackage";
        String retrieved = StringUtils.getPkgUUID(releaseId, (String)packageName);
        Assert.assertNotNull((Object)retrieved);
    }

    @Test
    public void getPkgUUIDFromGAV() {
        String gav = "group:artifact:version";
        String packageName = "apackage";
        String retrieved = StringUtils.getPkgUUID((String)gav, (String)packageName);
        String expected = StringUtils.md5Hash((String)(gav + packageName));
        Assert.assertEquals((Object)expected, (Object)retrieved);
    }

    private static class TestingReleaseId
    implements ReleaseId {
        final boolean snapshot;

        public TestingReleaseId(boolean snapshot) {
            this.snapshot = snapshot;
        }

        public String getGroupId() {
            return "group";
        }

        public String getArtifactId() {
            return "artifact";
        }

        public String getVersion() {
            return "version";
        }

        public String toExternalForm() {
            return "externalForm";
        }

        public boolean isSnapshot() {
            return this.snapshot;
        }
    }
}

