/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.drools.core.util.MethodUtils;
import org.junit.Test;

public class MethodUtilsTest {
    @Test
    public void testFindMethod() {
        Method m = MethodUtils.findMethod(Object.class, (String)"toString", (Class[])new Class[0]);
        Assertions.assertThat((Object)m).isNotNull();
        Assertions.assertThat((String)m.getName()).isEqualTo("toString");
        Assertions.assertThat((Object[])m.getParameters()).isEmpty();
    }

    @Test
    public void testFindIntMethodWithBigDecimal() {
        Method m = MethodUtils.findMethod(MyClass.class, (String)"methodInt", (Class[])new Class[]{BigDecimal.class});
        Assertions.assertThat((Object)m).isNotNull();
        Assertions.assertThat((String)m.getName()).isEqualTo("methodInt");
        Assertions.assertThat(this.parametersTypeName(m.getParameters())).containsExactly((Object[])new String[]{"int"});
    }

    @Test
    public void testFindObjectMethodWithString() {
        Method m = MethodUtils.findMethod(Map.class, (String)"get", (Class[])new Class[]{String.class});
        Assertions.assertThat((Object)m).isNotNull();
        Assertions.assertThat((String)m.getName()).isEqualTo("get");
        Assertions.assertThat(this.parametersTypeName(m.getParameters())).containsExactly((Object[])new String[]{"java.lang.Object"});
    }

    private Stream<String> parametersTypeName(Parameter[] parameters) {
        return Arrays.stream(parameters).map(Parameter::getType).map(Class::getCanonicalName);
    }

    public static class MyClass {
        public static int methodInt(int a) {
            return a;
        }
    }
}

