/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.drools.core.beliefsystem.ModedAssertion;
import org.drools.core.beliefsystem.simple.SimpleMode;
import org.drools.core.common.ActivationGroupNode;
import org.drools.core.common.ActivationNode;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalRuleFlowGroup;
import org.drools.core.common.LogicalDependency;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.reteoo.LeftTupleImpl;
import org.drools.core.rule.GroupElement;
import org.drools.core.spi.Activation;
import org.drools.core.spi.ConflictResolver;
import org.drools.core.spi.Consequence;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.BinaryHeapQueue;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListNode;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.rule.FactHandle;

public class BinaryHeapQueueTest {
    private List<Integer[]> perms = new ArrayList<Integer[]>();
    private static final int max = 6;

    private void shuffle(Integer[] a, int lim) {
        if (lim == 0) {
            Integer[] p = (Integer[])a.clone();
            this.perms.add(p);
        } else {
            this.shuffle(a, lim - 1);
            Integer h = a[lim];
            a[lim] = a[lim - 1];
            a[lim - 1] = h;
            this.shuffle(a, lim - 1);
        }
    }

    @Before
    public void setup() {
        System.out.println("Running setup");
        Integer[] a = new Integer[6];
        for (int i = 0; i < 6; ++i) {
            a[i] = i;
        }
        this.shuffle(a, 5);
    }

    @Test
    public void testShuffled() {
        for (Integer[] perm : this.perms) {
            int i2;
            Activation[] elems;
            Group group = new Group("group");
            for (Integer i2 : perm) {
                Item item = new Item(group, i2);
                group.add(item);
            }
            Activation[] activationArray = elems = group.getQueue();
            int n = activationArray.length;
            for (i2 = 0; i2 < n; ++i2) {
                Activation elem = activationArray[i2];
                Item item = (Item)elem;
                if (item.getQueueIndex() % 2 != 0) continue;
                group.remove(item);
                group.add(item);
            }
            boolean ok = true;
            StringBuilder sb = new StringBuilder("queue:");
            for (i2 = 5; i2 >= 0; --i2) {
                int sal = group.getNext().getSalience();
                sb.append(" ").append(sal);
                if (sal == i2) continue;
                ok = false;
            }
            Assert.assertTrue((String)("incorrect order in " + sb.toString()), (boolean)ok);
        }
    }

    public static class ItemConflictResolver
    implements ConflictResolver {
        private static final long serialVersionUID = 1L;
        public static final ItemConflictResolver INSTANCE = new ItemConflictResolver();

        public static ItemConflictResolver getInstance() {
            return INSTANCE;
        }

        public final int compare(Activation existing, Activation adding) {
            int s2;
            int s1 = existing.getSalience();
            if (s1 != (s2 = adding.getSalience())) {
                return s1 - s2;
            }
            return (int)(existing.getActivationNumber() - adding.getActivationNumber());
        }
    }

    public static class Item<T extends ModedAssertion<T>>
    implements Activation<T> {
        private static int actNo = 1;
        private int index;
        private long activationNumber;
        private Group group;
        private int salience;

        public Item(Group group, int salience) {
            this.group = group;
            this.salience = salience;
            this.activationNumber = actNo++;
        }

        public void dequeue() {
            if (this.group != null) {
                this.group.remove(this);
            }
            this.index = -1;
        }

        public void setQueueIndex(int index) {
            this.index = index;
        }

        public int getQueueIndex() {
            return this.index;
        }

        public int getSalience() {
            return this.salience;
        }

        public long getActivationNumber() {
            return this.activationNumber;
        }

        public void addLogicalDependency(LogicalDependency<T> arg0) {
        }

        public ActivationGroupNode getActivationGroupNode() {
            return null;
        }

        public ActivationNode getActivationNode() {
            return null;
        }

        public InternalAgendaGroup getAgendaGroup() {
            return null;
        }

        public InternalRuleFlowGroup getRuleFlowGroup() {
            return null;
        }

        public LinkedList<LogicalDependency<T>> getLogicalDependencies() {
            return null;
        }

        public PropagationContext getPropagationContext() {
            return null;
        }

        public RuleImpl getRule() {
            return null;
        }

        public Consequence getConsequence() {
            return null;
        }

        public GroupElement getSubRule() {
            return null;
        }

        public LeftTupleImpl getTuple() {
            return null;
        }

        public boolean isQueued() {
            return false;
        }

        public void remove() {
        }

        public void setQueued(boolean arg0) {
        }

        public void setActivationGroupNode(ActivationGroupNode arg0) {
        }

        public void setActivationNode(ActivationNode arg0) {
        }

        public void setLogicalDependencies(LinkedList<LogicalDependency<T>> arg0) {
        }

        public List<String> getDeclarationIds() {
            return null;
        }

        public Object getDeclarationValue(String arg0) {
            return null;
        }

        public List<? extends FactHandle> getFactHandles() {
            return null;
        }

        public List<Object> getObjects() {
            return null;
        }

        public InternalFactHandle getActivationFactHandle() {
            return null;
        }

        public boolean isAdded() {
            return false;
        }

        public void addBlocked(LogicalDependency node) {
        }

        public LinkedList<LogicalDependency<SimpleMode>> getBlocked() {
            return null;
        }

        public void setBlocked(LinkedList<LogicalDependency<SimpleMode>> justified) {
        }

        public void addBlocked(LinkedListNode<SimpleMode> node) {
        }

        public LinkedList getBlockers() {
            return null;
        }

        public boolean isMatched() {
            return false;
        }

        public void setMatched(boolean matched) {
        }

        public boolean isActive() {
            return false;
        }

        public void setActive(boolean active) {
        }

        public boolean isRuleAgendaItem() {
            return false;
        }
    }

    public static class Group {
        private static final long serialVersionUID = 510L;
        private String name;
        private BinaryHeapQueue queue;

        public Group() {
        }

        public Group(String name) {
            this.name = name;
            this.queue = new BinaryHeapQueue((Comparator)((Object)ItemConflictResolver.INSTANCE));
        }

        public String getName() {
            return this.name;
        }

        public void clear() {
            this.queue.clear();
        }

        public int size() {
            return this.queue.size();
        }

        public void add(Item item) {
            this.queue.enqueue((Activation)item);
        }

        public Item getNext() {
            return (Item)this.queue.dequeue();
        }

        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        public String toString() {
            return "AgendaGroup '" + this.name + "'";
        }

        public boolean equal(Object object) {
            if (object == null || !(object instanceof Group)) {
                return false;
            }
            return ((Group)object).name.equals(this.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public void remove(Item agendaItem) {
            this.queue.dequeue((Activation)agendaItem);
        }

        public Activation[] getQueue() {
            return (Activation[])this.queue.toArray((Object[])new Activation[this.size()]);
        }
    }
}

