/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base;

import java.util.HashSet;
import org.assertj.core.api.Assertions;
import org.drools.core.addon.ClassTypeResolver;
import org.drools.core.base.SimulateMacOSXClassLoader;
import org.drools.core.test.model.Cheese;
import org.drools.core.test.model.FirstClass;
import org.drools.core.test.model.Person;
import org.drools.core.test.model.SecondClass;
import org.junit.Test;

public class ClassTypeResolverTest {
    @Test
    public void testResolvePrimtiveTypes() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        Assertions.assertThat((Class)resolver.resolveType("boolean")).isEqualTo(Boolean.TYPE);
        Assertions.assertThat((Class)resolver.resolveType("double")).isEqualTo(Double.TYPE);
        Assertions.assertThat((Class)resolver.resolveType("float")).isEqualTo(Float.TYPE);
        Assertions.assertThat((Class)resolver.resolveType("int")).isEqualTo(Integer.TYPE);
        Assertions.assertThat((Class)resolver.resolveType("char")).isEqualTo(Character.TYPE);
        Assertions.assertThat((Class)resolver.resolveType("long")).isEqualTo(Long.TYPE);
        Assertions.assertThat((Class)resolver.resolveType("byte")).isEqualTo(Byte.TYPE);
        Assertions.assertThat((Class)resolver.resolveType("short")).isEqualTo(Short.TYPE);
    }

    @Test
    public void testResolveArrayOfPrimitiveTypes() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        Assertions.assertThat((Class)resolver.resolveType("boolean[]")).isEqualTo(boolean[].class);
        Assertions.assertThat((Class)resolver.resolveType("double[]")).isEqualTo(double[].class);
        Assertions.assertThat((Class)resolver.resolveType("float[]")).isEqualTo(float[].class);
        Assertions.assertThat((Class)resolver.resolveType("int[]")).isEqualTo(int[].class);
        Assertions.assertThat((Class)resolver.resolveType("char[]")).isEqualTo(char[].class);
        Assertions.assertThat((Class)resolver.resolveType("long[]")).isEqualTo(long[].class);
        Assertions.assertThat((Class)resolver.resolveType("byte[]")).isEqualTo(byte[].class);
        Assertions.assertThat((Class)resolver.resolveType("short[]")).isEqualTo(short[].class);
    }

    @Test
    public void testResolveMultidimensionnalArrayOfPrimitiveTypes() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        Assertions.assertThat((Class)resolver.resolveType("int[][]")).isEqualTo(int[][].class);
        Assertions.assertThat((Class)resolver.resolveType("int[][][]")).isEqualTo(int[][][].class);
        Assertions.assertThat((Class)resolver.resolveType("int[][][][]")).isEqualTo(int[][][][].class);
    }

    @Test
    public void testResolveObjectNotFromImport() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        Assertions.assertThat((Class)resolver.resolveType("String")).isEqualTo(String.class);
        Assertions.assertThat((Class)resolver.resolveType("java.lang.String")).isEqualTo(String.class);
        try {
            Assertions.assertThat((Class)resolver.resolveType("Cheese")).isEqualTo(Cheese.class);
            Assertions.fail((String)"Should raise a ClassNotFoundException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Assertions.assertThat((Class)resolver.resolveType("org.drools.core.test.model.Cheese")).isEqualTo(Cheese.class);
    }

    @Test
    public void testResolveObjectFromImport() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.core.test.model.Cheese");
        resolver.addImport("org.drools.core.test.model.FirstClass");
        resolver.addImport("org.drools.core.test.model.FirstClass.AlternativeKey");
        resolver.addImport("org.drools.core.test.model.SecondClass");
        resolver.addImport("org.drools.core.test.model.SecondClass.AlternativeKey");
        Assertions.assertThat((Class)resolver.resolveType("String")).isEqualTo(String.class);
        Assertions.assertThat((Class)resolver.resolveType("java.lang.String")).isEqualTo(String.class);
        Assertions.assertThat((Class)resolver.resolveType("Cheese")).isEqualTo(Cheese.class);
        Assertions.assertThat((Class)resolver.resolveType("org.drools.core.test.model.Cheese")).isEqualTo(Cheese.class);
        Assertions.assertThat((Class)resolver.resolveType("org.drools.core.test.model.FirstClass")).isEqualTo(FirstClass.class);
        Assertions.assertThat((Class)resolver.resolveType("org.drools.core.test.model.FirstClass.AlternativeKey")).isEqualTo(FirstClass.AlternativeKey.class);
        Assertions.assertThat((Class)resolver.resolveType("org.drools.core.test.model.SecondClass")).isEqualTo(SecondClass.class);
        Assertions.assertThat((Class)resolver.resolveType("org.drools.core.test.model.SecondClass.AlternativeKey")).isEqualTo(SecondClass.AlternativeKey.class);
    }

    @Test
    public void testResolveObjectFromImportNested() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.core.test.model.FirstClass");
        Assertions.assertThat((Class)resolver.resolveType("FirstClass.AlternativeKey")).isEqualTo(FirstClass.AlternativeKey.class);
    }

    @Test
    public void testResolveFullTypeName() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.core.test.model.Cheese");
        resolver.addImport("org.drools.core.test.model.FirstClass");
        Assertions.assertThat((String)resolver.getFullTypeName("Cheese")).isEqualTo("org.drools.core.test.model.Cheese");
        Assertions.assertThat((String)resolver.getFullTypeName("FirstClass")).isEqualTo("org.drools.core.test.model.FirstClass");
    }

    @Test
    public void testResolveObjectFromImportMultipleClassesDifferentPackages() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.core.test.model.Cheese");
        Assertions.assertThat((Class)resolver.resolveType("String")).isEqualTo(String.class);
        Assertions.assertThat((Class)resolver.resolveType("java.lang.String")).isEqualTo(String.class);
        Assertions.assertThat((Class)resolver.resolveType("Cheese")).isEqualTo(Cheese.class);
        Assertions.assertThat((Class)resolver.resolveType("org.drools.core.test.model.Cheese")).isEqualTo(Cheese.class);
    }

    @Test
    public void testResolveArrayOfObjectsNotFromImport() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        Assertions.assertThat((Class)resolver.resolveType("String[]")).isEqualTo(String[].class);
        Assertions.assertThat((Class)resolver.resolveType("java.lang.String[]")).isEqualTo(String[].class);
        try {
            Assertions.assertThat((Class)resolver.resolveType("Cheese[]")).isEqualTo(Cheese[].class);
            Assertions.fail((String)"Should raise a ClassNotFoundException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Assertions.assertThat((Class)resolver.resolveType("org.drools.core.test.model.Cheese[]")).isEqualTo(Cheese[].class);
    }

    @Test
    public void testResolveArrayOfObjectsFromImport() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.core.test.model.Cheese");
        Assertions.assertThat((Class)resolver.resolveType("String[]")).isEqualTo(String[].class);
        Assertions.assertThat((Class)resolver.resolveType("java.lang.String[]")).isEqualTo(String[].class);
        Assertions.assertThat((Class)resolver.resolveType("Cheese[]")).isEqualTo(Cheese[].class);
        Assertions.assertThat((Class)resolver.resolveType("org.drools.core.test.model.Cheese[]")).isEqualTo(Cheese[].class);
    }

    @Test
    public void testResolveMultidimensionnalArrayOfObjectsNotFromImport() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        Assertions.assertThat((Class)resolver.resolveType("String[][]")).isEqualTo(String[][].class);
        Assertions.assertThat((Class)resolver.resolveType("java.lang.String[][]")).isEqualTo(String[][].class);
        try {
            Assertions.assertThat((Class)resolver.resolveType("Cheese[][]")).isEqualTo(Cheese[][].class);
            Assertions.fail((String)"Should raise a ClassNotFoundException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Assertions.assertThat((Class)resolver.resolveType("org.drools.core.test.model.Cheese[][]")).isEqualTo(Cheese[][].class);
    }

    @Test
    public void testResolveMultidimensionnalArrayOfObjectsFromImport() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.core.test.model.Cheese");
        Assertions.assertThat((Class)resolver.resolveType("String[][]")).isEqualTo(String[][].class);
        Assertions.assertThat((Class)resolver.resolveType("java.lang.String[][]")).isEqualTo(String[][].class);
        Assertions.assertThat((Class)resolver.resolveType("Cheese[][]")).isEqualTo(Cheese[][].class);
        Assertions.assertThat((Class)resolver.resolveType("org.drools.core.test.model.Cheese[][]")).isEqualTo(Cheese[][].class);
    }

    @Test
    public void testDefaultPackageImport() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("Goo");
        try {
            resolver.resolveType("Goo");
            Assertions.fail((String)"Can't import default namespace classes");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testNestedClassResolving() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.core.test.model.Person.Nested1");
        Assertions.assertThat((Class)resolver.resolveType("Nested1")).isEqualTo(Person.Nested1.class);
        resolver.addImport("org.drools.core.test.model.Person.Nested1.Nested2");
        Assertions.assertThat((Class)resolver.resolveType("Nested2")).isEqualTo(Person.Nested1.Nested2.class);
        resolver.addImport("org.drools.core.test.model.Person.Nested1.Nested2.Nested3");
        Assertions.assertThat((Class)resolver.resolveType("Nested3")).isEqualTo(Person.Nested1.Nested2.Nested3.class);
    }

    @Test
    public void testMacOSXClassLoaderBehavior() throws Exception {
        SimulateMacOSXClassLoader simulatedMacOSXClassLoader = new SimulateMacOSXClassLoader(Thread.currentThread().getContextClassLoader(), new HashSet());
        simulatedMacOSXClassLoader.addClassInScope(Cheese.class);
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), (ClassLoader)simulatedMacOSXClassLoader);
        resolver.addImport("org.drools.core.test.model.*");
        Assertions.assertThat((Class)resolver.resolveType("Cheese")).isEqualTo(Cheese.class);
        try {
            resolver.resolveType("cheese");
            Assertions.fail((String)"the type cheese (lower-case c) should not exists at all");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testMacOSXClassLoaderBehaviorNested() throws Exception {
        SimulateMacOSXClassLoader simulatedMacOSXClassLoader = new SimulateMacOSXClassLoader(Thread.currentThread().getContextClassLoader(), new HashSet());
        simulatedMacOSXClassLoader.addClassInScope(Person.Nested1.Nested2.class);
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), (ClassLoader)simulatedMacOSXClassLoader);
        resolver.addImport("org.drools.core.test.model.*");
        Assertions.assertThat((Class)resolver.resolveType("Person.Nested1.Nested2")).isEqualTo(Person.Nested1.Nested2.class);
        try {
            resolver.resolveType("Person.nested1.nested2");
            Assertions.fail((String)"should have resolved nothing.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

