/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.runtime.rule;

import org.assertj.core.api.Assertions;
import org.drools.core.command.runtime.rule.DeleteCommand;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.ExecutableRunner;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.RequestContext;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.command.RegistryContext;

public class DeleteCommandTest {
    private KieSession ksession;
    private ExecutableRunner<RequestContext> runner;
    private Context context;

    @Before
    public void setup() {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        this.ksession = kbase.newKieSession();
        this.runner = ExecutableRunner.create();
        this.context = ((RegistryContext)this.runner.createContext()).register(KieSession.class, (Object)this.ksession);
    }

    @After
    public void cleanUp() {
        this.ksession.dispose();
    }

    @Test
    public void testDeleteDisconnectedNonExistingFactHandle() {
        String fact = "fact";
        InsertObjectCommand insertObjectCommand = new InsertObjectCommand((Object)fact);
        FactHandle handle = (FactHandle)this.runner.execute((Command)insertObjectCommand, this.context);
        DeleteCommand deleteCommand1 = new DeleteCommand(handle);
        this.runner.execute((Command)deleteCommand1, this.context);
        DeleteCommand deleteCommand2 = new DeleteCommand(handle);
        this.runner.execute((Command)deleteCommand2, this.context);
        Assertions.assertThat((long)this.ksession.getFactCount()).isEqualTo(0L);
    }
}

