/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.test.model;

import java.util.Properties;
import org.assertj.core.api.Assertions;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.PriorityQueueAgendaGroupFactory;
import org.junit.Test;

public class RuleBaseConfigurationTest {
    @Test
    public void testSystemProperties() {
        RuleBaseConfiguration cfg = new RuleBaseConfiguration();
        Assertions.assertThat((Object)cfg.getAssertBehaviour()).isEqualTo((Object)RuleBaseConfiguration.AssertBehaviour.IDENTITY);
        System.setProperty("drools.equalityBehavior", "EQUALITY");
        cfg = new RuleBaseConfiguration();
        Assertions.assertThat((Object)cfg.getAssertBehaviour()).isEqualTo((Object)RuleBaseConfiguration.AssertBehaviour.EQUALITY);
        System.getProperties().remove("drools.equalityBehavior");
    }

    @Test
    public void testProgrammaticPropertiesFile() {
        RuleBaseConfiguration cfg = new RuleBaseConfiguration();
        Assertions.assertThat((boolean)cfg.isIndexLeftBetaMemory()).isEqualTo(true);
        Properties properties = new Properties();
        properties.setProperty("drools.indexLeftBetaMemory", "false");
        cfg = new RuleBaseConfiguration(properties);
        Assertions.assertThat((boolean)cfg.isIndexLeftBetaMemory()).isEqualTo(false);
        System.getProperties().remove("drools.indexLeftBetaMemory");
    }

    @Test
    public void testAssertBehaviour() {
        Properties properties = new Properties();
        properties.setProperty("drools.equalityBehavior", "identity");
        RuleBaseConfiguration cfg = new RuleBaseConfiguration(properties);
        Assertions.assertThat((Object)cfg.getAssertBehaviour()).isEqualTo((Object)RuleBaseConfiguration.AssertBehaviour.IDENTITY);
        properties = new Properties();
        properties.setProperty("drools.equalityBehavior", "equality");
        cfg = new RuleBaseConfiguration(properties);
        Assertions.assertThat((Object)cfg.getAssertBehaviour()).isEqualTo((Object)RuleBaseConfiguration.AssertBehaviour.EQUALITY);
    }

    @Test
    public void testSequential() {
        Properties properties = new Properties();
        properties.setProperty("drools.sequential", "false");
        RuleBaseConfiguration cfg = new RuleBaseConfiguration(properties);
        Assertions.assertThat((boolean)cfg.isSequential()).isFalse();
        Assertions.assertThat((boolean)(cfg.getAgendaGroupFactory() instanceof PriorityQueueAgendaGroupFactory)).isTrue();
        properties = new Properties();
        properties.setProperty("drools.sequential.agenda", "sequential");
        properties.setProperty("drools.sequential", "true");
        cfg = new RuleBaseConfiguration(properties);
        Assertions.assertThat((boolean)cfg.isSequential()).isTrue();
        Assertions.assertThat((Object)cfg.getSequentialAgenda()).isEqualTo((Object)RuleBaseConfiguration.SequentialAgenda.SEQUENTIAL);
        properties = new Properties();
        properties.setProperty("drools.sequential.agenda", "dynamic");
        properties.setProperty("drools.sequential", "true");
        cfg = new RuleBaseConfiguration(properties);
        Assertions.assertThat((boolean)cfg.isSequential()).isTrue();
        Assertions.assertThat((Object)cfg.getSequentialAgenda()).isEqualTo((Object)RuleBaseConfiguration.SequentialAgenda.DYNAMIC);
        Assertions.assertThat((boolean)(cfg.getAgendaGroupFactory() instanceof PriorityQueueAgendaGroupFactory)).isTrue();
    }
}

