/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.evaluators;

import org.assertj.core.api.Assertions;
import org.drools.core.base.evaluators.TimeIntervalParser;
import org.junit.Test;

public class TimeIntervalParserTest {
    @Test
    public void testParse() {
        String input = "2d10h49m10s789ms";
        long expected = 211750789L;
        long[] result = TimeIntervalParser.parse((String)input);
        Assertions.assertThat((long[])result).hasSize(1);
        Assertions.assertThat((long)result[0]).isEqualTo(expected);
    }

    @Test
    public void testParse2() {
        String input = "10h49m789ms";
        long expected = 38940789L;
        long[] result = TimeIntervalParser.parse((String)input);
        Assertions.assertThat((long[])result).hasSize(1);
        Assertions.assertThat((long)result[0]).isEqualTo(expected);
    }

    @Test
    public void testParse3() {
        String input = " 10h49m789 , 12h ";
        long expected1 = 38940789L;
        long expected2 = 43200000L;
        long[] result = TimeIntervalParser.parse((String)input);
        Assertions.assertThat((long[])result).hasSize(2);
        Assertions.assertThat((long)result[0]).isEqualTo(expected1);
        Assertions.assertThat((long)result[1]).isEqualTo(expected2);
    }

    @Test
    public void testParse4() {
        String input = " 15957, 3500000 ";
        long expected1 = 15957L;
        long expected2 = 3500000L;
        long[] result = TimeIntervalParser.parse((String)input);
        Assertions.assertThat((long[])result).hasSize(2);
        Assertions.assertThat((long)result[0]).isEqualTo(expected1);
        Assertions.assertThat((long)result[1]).isEqualTo(expected2);
    }

    @Test
    public void testParse5() {
        String input = "";
        long[] result = TimeIntervalParser.parse((String)input);
        Assertions.assertThat((long[])result).hasSize(0);
    }

    @Test
    public void testParse6() {
        String input = null;
        long[] result = TimeIntervalParser.parse(input);
        Assertions.assertThat((long[])result).hasSize(0);
    }

    @Test
    public void testParse7() {
        String input = "  ";
        long[] result = TimeIntervalParser.parse((String)input);
        Assertions.assertThat((long[])result).hasSize(0);
    }

    @Test
    public void testParse8() {
        String input = " -15957, 3500000 ";
        long expected1 = -15957L;
        long expected2 = 3500000L;
        long[] result = TimeIntervalParser.parse((String)input);
        Assertions.assertThat((long[])result).hasSize(2);
        Assertions.assertThat((long)result[0]).isEqualTo(expected1);
        Assertions.assertThat((long)result[1]).isEqualTo(expected2);
    }

    @Test
    public void testParse9() {
        String input = " -10h49m789 , -8h ";
        long expected1 = -38940789L;
        long expected2 = -28800000L;
        long[] result = TimeIntervalParser.parse((String)input);
        Assertions.assertThat((long[])result).hasSize(2);
        Assertions.assertThat((long)result[0]).isEqualTo(expected1);
        Assertions.assertThat((long)result[1]).isEqualTo(expected2);
    }
}

