/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.common.TruthMaintenanceSystem;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.rule.EntryPointId;
import org.drools.core.test.model.MockActivation;
import org.junit.Before;
import org.junit.Test;

public class LazyTMSEnablingTest {
    private StatefulKnowledgeSessionImpl ksession;
    private TruthMaintenanceSystem tms;

    @Before
    public void setUp() {
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        this.ksession = (StatefulKnowledgeSessionImpl)kBase.newKieSession();
        this.tms = ((NamedEntryPoint)this.ksession.getWorkingMemoryEntryPoint(EntryPointId.DEFAULT.getEntryPointId())).getTruthMaintenanceSystem();
    }

    @Test
    public void shouldLazilyAdd() throws Exception {
        String fact1 = "logical";
        this.ksession.insert((Object)"logical");
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.tms.getEqualityKeyMap().size()).as("Shouldn't have anything, since no logical insert was performed.", new Object[0])).isEqualTo(0);
        String fact2 = "logical";
        this.ksession.getTruthMaintenanceSystem().insert((Object)"logical", null, null, new MockActivation());
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.tms.getEqualityKeyMap().size()).as("Now that a logical insert was done, it should have an element.", new Object[0])).isEqualTo(1);
        ObjectTypeConf typeConf = this.ksession.getObjectTypeConfigurationRegistry().getOrCreateObjectTypeConf(this.ksession.getEntryPoint(), (Object)"logical");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)typeConf.isTMSEnabled()).as("Should have enabled TMS", new Object[0])).isTrue();
    }

    @Test
    public void shouldEnableTMSForSpecificType() throws Exception {
        String stringFact1 = "toto";
        String stringFact2 = "toto";
        String anotherString = "tata";
        Integer intFact1 = 99;
        Integer intFact2 = 99;
        Double doubleFact = 77.8;
        ObjectTypeConf stringTypeConf = this.ksession.getObjectTypeConfigurationRegistry().getOrCreateObjectTypeConf(this.ksession.getEntryPoint(), (Object)"toto");
        ObjectTypeConf intTypeConf = this.ksession.getObjectTypeConfigurationRegistry().getOrCreateObjectTypeConf(this.ksession.getEntryPoint(), (Object)intFact1);
        this.ksession.insert((Object)"toto");
        this.ksession.insert((Object)"tata");
        this.ksession.insert((Object)intFact1);
        this.ksession.insert((Object)doubleFact);
        for (ObjectTypeConf conf : this.ksession.getObjectTypeConfigurationRegistry().values()) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)conf.isTMSEnabled()).as("TMS shouldn't be enabled for any type, since no logical insert was done.", new Object[0])).isFalse();
        }
        this.ksession.getTruthMaintenanceSystem().insert((Object)"toto", null, null, new MockActivation());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)stringTypeConf.isTMSEnabled()).as("Should have enabled TMS for Strings.", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)intTypeConf.isTMSEnabled()).as("Shouldn't have enabled TMS for Integers.", new Object[0])).isFalse();
        this.ksession.getTruthMaintenanceSystem().insert((Object)intFact2, null, null, new MockActivation());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)intTypeConf.isTMSEnabled()).as("Now it should have enabled TMS for Integers!.", new Object[0])).isTrue();
    }
}

