/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.DisconnectedFactHandle;
import org.drools.core.common.DisconnectedWorkingMemoryEntryPoint;
import org.junit.Test;

public class FactHandleTest {
    @Test
    public void testFactHandleImpllong() {
        DefaultFactHandle f0 = new DefaultFactHandle(134L, (Object)"cheese");
        Assertions.assertThat((long)f0.getId()).isEqualTo(134L);
        Assertions.assertThat((long)f0.getRecency()).isEqualTo(134L);
    }

    @Test
    public void testFactHandleImpllonglong() {
        DefaultFactHandle f0 = new DefaultFactHandle(134L, (Object)"cheese", 678L, (WorkingMemoryEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        Assertions.assertThat((long)f0.getId()).isEqualTo(134L);
        Assertions.assertThat((long)f0.getRecency()).isEqualTo(678L);
    }

    @Test
    public void testEqualsObject() {
        DefaultFactHandle f0 = new DefaultFactHandle(134L, (Object)"cheese");
        DefaultFactHandle f1 = new DefaultFactHandle(96L, (Object)"cheese");
        DefaultFactHandle f3 = new DefaultFactHandle(96L, (Object)"cheese");
        ((ObjectAssert)Assertions.assertThat((Object)f0).as("f0 should not equal f1", new Object[0])).isNotEqualTo((Object)f1);
        Assertions.assertThat((Object)f3).isEqualTo((Object)f1);
        Assertions.assertThat((Object)f3).isNotSameAs((Object)f1);
    }

    @Test
    public void testHashCode() {
        DefaultFactHandle f0 = new DefaultFactHandle(234L, (Object)"cheese");
        Assertions.assertThat((int)f0.getObjectHashCode()).isEqualTo("cheese".hashCode());
        Assertions.assertThat((Object)f0).hasSameHashCodeAs((Object)234);
    }

    @Test
    public void testInvalidate() {
        DefaultFactHandle f0 = new DefaultFactHandle(134L, (Object)"cheese");
        Assertions.assertThat((long)f0.getId()).isEqualTo(134L);
        f0.invalidate();
        Assertions.assertThat((long)f0.getId()).isEqualTo(134L);
    }

    @Test
    public void testDefaultFactHandleCreateFromExternalFormat() {
        String externalFormat = "0:2147483648:171497379:-1361525545:2147483648:null:NON_TRAIT:java.lang.String";
        DefaultFactHandle f0 = DefaultFactHandle.createFromExternalFormat((String)externalFormat);
        Assertions.assertThat((long)f0.getId()).isEqualTo(0x80000000L);
    }

    @Test
    public void testDisconnectedFactHandleCreateFromExternalFormat() {
        String externalFormat = "0:2147483648:171497379:-1361525545:2147483648:null:NON_TRAIT:java.lang.String";
        DisconnectedFactHandle f0 = new DisconnectedFactHandle(externalFormat);
        Assertions.assertThat((long)f0.getId()).isEqualTo(0x80000000L);
    }
}

