/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import org.assertj.core.api.Assertions;
import org.drools.core.util.ClassUtils;
import org.junit.Test;

public class ClassUtilsTest {
    @Test
    public void testCanonicalNameSimpleClass() {
        String name = ClassUtils.canonicalName(ClassUtilsTest.class);
        Assertions.assertThat((String)name).isEqualTo("org.drools.core.util.ClassUtilsTest");
    }

    @Test
    public void testCanonicalNameInnerClass() {
        String name = ClassUtils.canonicalName(A.class);
        Assertions.assertThat((String)name).isEqualTo("org.drools.core.util.ClassUtilsTest.A");
    }

    @Test
    public void testCanonicalNameInnerInnerClass() {
        String name = ClassUtils.canonicalName(A.B.class);
        Assertions.assertThat((String)name).isEqualTo("org.drools.core.util.ClassUtilsTest.A.B");
    }

    @Test
    public void testCanonicalNameArray() {
        String name = ClassUtils.canonicalName(Object[].class);
        Assertions.assertThat((String)name).isEqualTo("java.lang.Object[]");
    }

    @Test
    public void testCanonicalNameMultiIndexArray() {
        String name = ClassUtils.canonicalName(Object[][][].class);
        Assertions.assertThat((String)name).isEqualTo("java.lang.Object[][][]");
    }

    @Test
    public void testCanonicalNameMultiIndexArrayInnerClass() {
        String name = ClassUtils.canonicalName(A.B[][][].class);
        Assertions.assertThat((String)name).isEqualTo("org.drools.core.util.ClassUtilsTest.A.B[][][]");
    }

    @Test
    public void testCanonicalNameMultiIndexArrayPrimitives() {
        String name = ClassUtils.canonicalName(long[][][].class);
        Assertions.assertThat((String)name).isEqualTo("long[][][]");
    }

    public static class A {

        public static class B {
        }
    }
}

