/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.util.List;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.drools.core.util.StringUtils;
import org.junit.Test;
import org.kie.api.builder.ReleaseId;

public class StringUtilsTest {
    @Test
    public void testFindEndOfMethodArgsIndex() {
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId(\"myId\")", 12);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId(\"myId\").call()", 12);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId('myId')", 12);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId('myId').call()", 12);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId(\"my'Id\")", 13);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId(\"my'Id\").call()", 13);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId(\"my'Id'\")", 14);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId(\"my'Id'\").call()", 14);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId('my\"Id\"')", 14);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId('my\"Id\"').call()", 14);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId('my\"Id')", 13);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId('my\"Id').call()", 13);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId(\"my\\\"Id\")", 14);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId(\"my\\\"Id\").call()", 14);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId('myId', 'something')", 25);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId(\"myId\", \"something\")", 25);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId(\"my'Id\", \"somet'hing\")", 27);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId(\"my'Id'\", \"somet'hing\")", 28);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setId(\"my'(Id\", \"somet'(hing'\")", 30);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setObject(new Object())", 22);
        this.findEndOfMethodArgsIndexAndAssertItEqualsToExpected("setObject(new Object(\"string param\"))", 36);
    }

    private void findEndOfMethodArgsIndexAndAssertItEqualsToExpected(String strExpr, int expectedIndex) {
        int actualIndex = StringUtils.findEndOfMethodArgsIndex((CharSequence)strExpr, (int)strExpr.indexOf(40));
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualIndex).as("Expected and actual end of method args index for expr '" + strExpr + "' are not equal!", new Object[0])).isEqualTo(expectedIndex);
    }

    @Test
    public void test_codeAwareEqualsIgnoreSpaces() {
        Assertions.assertThat((boolean)StringUtils.codeAwareEqualsIgnoreSpaces(null, null)).isTrue();
        Assertions.assertThat((boolean)StringUtils.codeAwareEqualsIgnoreSpaces((String)"", (String)"")).isTrue();
        Assertions.assertThat((boolean)StringUtils.codeAwareEqualsIgnoreSpaces((String)"", null)).isFalse();
        Assertions.assertThat((boolean)StringUtils.codeAwareEqualsIgnoreSpaces(null, (String)"")).isFalse();
        Assertions.assertThat((boolean)StringUtils.codeAwareEqualsIgnoreSpaces((String)" ", (String)"")).isTrue();
        Assertions.assertThat((boolean)StringUtils.codeAwareEqualsIgnoreSpaces((String)"", (String)" ")).isTrue();
        Assertions.assertThat((boolean)StringUtils.codeAwareEqualsIgnoreSpaces((String)" ", (String)"  ")).isTrue();
        Assertions.assertThat((boolean)StringUtils.codeAwareEqualsIgnoreSpaces((String)"rule Rx when then end", (String)" rule Rx  when then end ")).isTrue();
        Assertions.assertThat((boolean)StringUtils.codeAwareEqualsIgnoreSpaces((String)"rule Rx when then end\n", (String)" rule Rx  when then end\n ")).isTrue();
        Assertions.assertThat((boolean)StringUtils.codeAwareEqualsIgnoreSpaces((String)"package org.drools.compiler\n", (String)"package org.drools.compiler\n rule Rx when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n")).isFalse();
        Assertions.assertThat((boolean)StringUtils.codeAwareEqualsIgnoreSpaces((String)"package org.drools.compiler\nrule Rx when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n", (String)"package org.drools.compiler\n rule Rx when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n")).isTrue();
        Assertions.assertThat((boolean)StringUtils.codeAwareEqualsIgnoreSpaces((String)"package org.drools.compiler\nrule Rx when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n", (String)" package org.drools.compiler\nrule Rx when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n")).isTrue();
        Assertions.assertThat((boolean)StringUtils.codeAwareEqualsIgnoreSpaces((String)"package org.drools.compiler\nrule Rx when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n", (String)" package org.drools.compiler\n rule Rx when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n ")).isTrue();
        Assertions.assertThat((boolean)StringUtils.codeAwareEqualsIgnoreSpaces((String)"package org.drools.compiler\nrule Rx when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n", (String)"package org.drools.compiler\nrule Rx when\n   $m : Message( message == \"Hello World\"  )\nthen\nend\n")).isTrue();
        Assertions.assertThat((boolean)StringUtils.codeAwareEqualsIgnoreSpaces((String)"package org.drools.compiler\nrule Rx when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n", (String)"package org.drools.compiler\nrule Rx when\n   $m : Message( message == \"Hello    World\" )\nthen\nend\n")).isFalse();
        Assertions.assertThat((boolean)StringUtils.codeAwareEqualsIgnoreSpaces((String)"package org.drools.compiler\nrule Rx when\n   $m : Message( message == \"Hello' World\" )\nthen\nend\n", (String)"package org.drools.compiler\nrule Rx when\n   $m : Message( message == \"Hello'    World\" )\nthen\nend\n")).isFalse();
        Assertions.assertThat((boolean)StringUtils.codeAwareEqualsIgnoreSpaces((String)"package org.drools.compiler\nrule Rx when\n   $m : Message( message == 'Hello World' )\nthen\nend\n", (String)"package org.drools.compiler\nrule Rx when\n   $m : Message( message == 'Hello    World' )\nthen\nend\n")).isFalse();
        Assertions.assertThat((boolean)StringUtils.codeAwareEqualsIgnoreSpaces((String)"package org.drools.compiler\nrule Rx when\n   $m : Message( message == 'Hello\" World' )\nthen\nend\n", (String)"package org.drools.compiler\nrule Rx when\n   $m : Message( message == 'Hello\"    World' )\nthen\nend\n")).isFalse();
        Assertions.assertThat((boolean)StringUtils.codeAwareEqualsIgnoreSpaces((String)"package org.drools.compiler\nrule Rx when\n   $m : Message( message == 'Hello\\' World' )\nthen\nend\n", (String)"package org.drools.compiler\nrule Rx when\n   $m : Message( message == 'Hello\\'    World' )\nthen\nend\n")).isFalse();
    }

    @Test
    public void test_indexOfOutOfQuotes() {
        Assertions.assertThat((int)StringUtils.indexOfOutOfQuotes((String)"bla\"bla\"bla", (String)"bla")).isEqualTo(0);
        Assertions.assertThat((int)StringUtils.indexOfOutOfQuotes((String)"\"bla\"bla", (String)"bla")).isEqualTo(5);
        Assertions.assertThat((int)StringUtils.indexOfOutOfQuotes((String)"\"bla\"", (String)"bla")).isEqualTo(-1);
        Assertions.assertThat((int)StringUtils.indexOfOutOfQuotes((String)"bla\"bla\"bla", (String)"bla", (int)0)).isEqualTo(0);
        Assertions.assertThat((int)StringUtils.indexOfOutOfQuotes((String)"bla\"bla\"bla", (String)"bla", (int)1)).isEqualTo(8);
        Assertions.assertThat((int)StringUtils.indexOfOutOfQuotes((String)"bla\"bla\"bla", (String)"bla", (int)9)).isEqualTo(-1);
    }

    @Test
    public void getPkgUUIDFromReleaseIdNotNullNotSnapshot() {
        TestingReleaseId releaseId = new TestingReleaseId(false);
        String packageName = "apackage";
        String retrieved = StringUtils.getPkgUUID((ReleaseId)releaseId, (String)packageName);
        String expected = StringUtils.md5Hash((String)(releaseId.toString() + packageName));
        Assertions.assertThat((String)retrieved).isEqualTo(expected);
    }

    @Test
    public void getPkgUUIDFromReleaseIdNotNullSnapshot() {
        TestingReleaseId releaseId = new TestingReleaseId(true);
        String packageName = "apackage";
        String retrieved = StringUtils.getPkgUUID((ReleaseId)releaseId, (String)packageName);
        String unexpected = StringUtils.md5Hash((String)(releaseId.toString() + packageName));
        Assertions.assertThat((String)retrieved).isNotEqualTo((Object)unexpected);
    }

    @Test
    public void getPkgUUIDFromReleaseIdNull() {
        ReleaseId releaseId = null;
        String packageName = "apackage";
        String retrieved = StringUtils.getPkgUUID(releaseId, (String)packageName);
        Assertions.assertThat((String)retrieved).isNotNull();
    }

    @Test
    public void getPkgUUIDFromGAV() {
        String gav = "group:artifact:version";
        String packageName = "apackage";
        String retrieved = StringUtils.getPkgUUID((String)gav, (String)packageName);
        String expected = StringUtils.md5Hash((String)(gav + packageName));
        Assertions.assertThat((String)retrieved).isEqualTo(expected);
    }

    @Test
    public void testSplitStatements() {
        String text = "System.out.println(\"'\");$visaApplication.setValidation( Validation.FAILED );drools.update($visaApplication);";
        List statements = StringUtils.splitStatements((CharSequence)text);
        Assertions.assertThat((int)statements.size()).isEqualTo(3);
        Assertions.assertThat((String)((String)statements.get(0))).isEqualTo("System.out.println(\"'\")");
        Assertions.assertThat((String)((String)statements.get(1))).isEqualTo("$visaApplication.setValidation( Validation.FAILED )");
        Assertions.assertThat((String)((String)statements.get(2))).isEqualTo("drools.update($visaApplication)");
    }

    private static class TestingReleaseId
    implements ReleaseId {
        final boolean snapshot;

        public TestingReleaseId(boolean snapshot) {
            this.snapshot = snapshot;
        }

        public String getGroupId() {
            return "group";
        }

        public String getArtifactId() {
            return "artifact";
        }

        public String getVersion() {
            return "version";
        }

        public String toExternalForm() {
            return "externalForm";
        }

        public boolean isSnapshot() {
            return this.snapshot;
        }
    }
}

