/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.xml;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.core.io.internal.InternalResource;
import org.drools.core.xml.ChangeSetSemanticModule;
import org.drools.core.xml.SemanticModule;
import org.drools.core.xml.SemanticModules;
import org.drools.core.xml.XmlChangeSetReader;
import org.junit.Test;
import org.kie.api.io.Resource;
import org.kie.internal.ChangeSet;

public class XmlChangeSetReaderTest {
    @Test
    public void testResourceAttributes() throws Exception {
        SemanticModules semanticModules = new SemanticModules();
        semanticModules.addSemanticModule((SemanticModule)new ChangeSetSemanticModule());
        XmlChangeSetReader changeSetReader = new XmlChangeSetReader(semanticModules);
        changeSetReader.setClassLoader(XmlChangeSetReaderTest.class.getClassLoader(), null);
        ChangeSet changeSet = changeSetReader.read(XmlChangeSetReaderTest.class.getClassLoader().getResourceAsStream("org/drools/core/xml/test-change-set.xml"));
        Assertions.assertThat((Object)changeSet).isNotNull();
        Collection resourcesAdded = changeSet.getResourcesAdded();
        Assertions.assertThat((Iterable)resourcesAdded).isNotNull();
        Assertions.assertThat((int)resourcesAdded.size()).isEqualTo(4);
        InternalResource resource1 = null;
        InternalResource resource2 = null;
        InternalResource resource3 = null;
        InternalResource secureResource = null;
        for (Resource r : resourcesAdded) {
            InternalResource resource = (InternalResource)r;
            if (resource.getSourcePath() != null && resource.getSourcePath().equals("resource1")) {
                resource1 = resource;
                continue;
            }
            if (resource.getSourcePath() != null && resource.getSourcePath().equals("secureResource")) {
                secureResource = resource;
                continue;
            }
            if (resource.getSourcePath() == null && resource.getDescription() == null) {
                resource3 = resource;
                continue;
            }
            if (resource.getSourcePath() != null) continue;
            resource2 = resource;
        }
        Assertions.assertThat(resource1).isNotNull();
        Assertions.assertThat(resource2).isNotNull();
        Assertions.assertThat(resource3).isNotNull();
        Assertions.assertThat(secureResource).isNotNull();
        Assertions.assertThat((String)resource1.getDescription()).isNull();
        Assertions.assertThat((String)resource2.getDescription()).isEqualTo("another description");
        Assertions.assertThat((String)secureResource.getDescription()).isEqualTo("some useful description");
        Assertions.assertThat((int)changeSetReader.getParser().getAttrs().getLength()).isEqualTo(2);
        Assertions.assertThat((String)changeSetReader.getParser().getAttrs().getValue("type")).isEqualTo("DRL");
    }
}

