/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.WorkingMemory;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkPropagator;
import org.drools.core.reteoo.SingleLeftTupleSinkAdapter;
import org.drools.core.rule.EvalCondition;
import org.drools.core.spi.Tuple;

public class ConditionalBranchEvaluator
implements Externalizable {
    private EvalCondition condition;
    private ConditionalBranchEvaluator elseBranchEvaluator;
    private ConditionalExecution conditionalExecution;

    public ConditionalBranchEvaluator() {
    }

    public ConditionalBranchEvaluator(EvalCondition condition, RuleBasePartitionId partitionId, LeftTupleSink tupleSink, boolean breaking, ConditionalBranchEvaluator elseBranchEvaluator) {
        this.condition = condition;
        this.elseBranchEvaluator = elseBranchEvaluator;
        this.conditionalExecution = new ConditionalExecution(partitionId, tupleSink, breaking);
    }

    public ConditionalBranchEvaluator getElseBranchEvaluator() {
        return this.elseBranchEvaluator;
    }

    public ConditionalExecution evaluate(Tuple tuple, WorkingMemory workingMemory, Object context) {
        if (this.condition.isAllowed(tuple = tuple.skipEmptyHandles(), workingMemory, context)) {
            return this.conditionalExecution;
        }
        return this.elseBranchEvaluator == null ? null : this.elseBranchEvaluator.evaluate(tuple, workingMemory, context);
    }

    public Object createContext() {
        return this.condition.createContext();
    }

    public int hashCode() {
        return this.condition.hashCode() + (this.elseBranchEvaluator == null ? 0 : this.elseBranchEvaluator.hashCode());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConditionalBranchEvaluator)) {
            return false;
        }
        ConditionalBranchEvaluator other = (ConditionalBranchEvaluator)obj;
        if (!this.condition.equals(other.condition)) {
            return false;
        }
        return this.elseBranchEvaluator == null ? other.elseBranchEvaluator == null : this.elseBranchEvaluator.equals(other.elseBranchEvaluator);
    }

    public String toString() {
        return "if ( " + this.condition + " ) " + this.conditionalExecution + (this.elseBranchEvaluator != null ? " else " + this.elseBranchEvaluator.toString() : "");
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.condition);
        out.writeObject(this.conditionalExecution);
        out.writeObject(this.elseBranchEvaluator);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.condition = (EvalCondition)in.readObject();
        this.conditionalExecution = (ConditionalExecution)in.readObject();
        this.elseBranchEvaluator = (ConditionalBranchEvaluator)in.readObject();
    }

    public static class ConditionalExecution
    implements Externalizable {
        private LeftTupleSinkPropagator sink;
        private boolean breaking;

        public ConditionalExecution() {
        }

        private ConditionalExecution(RuleBasePartitionId partitionId, LeftTupleSink tupleSink, boolean breaking) {
            this.sink = new SingleLeftTupleSinkAdapter(partitionId, tupleSink);
            this.breaking = breaking;
        }

        public LeftTupleSinkPropagator getSink() {
            return this.sink;
        }

        public boolean isBreaking() {
            return this.breaking;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.sink);
            out.writeBoolean(this.breaking);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.sink = (LeftTupleSinkPropagator)in.readObject();
            this.breaking = in.readBoolean();
        }

        public String toString() {
            return (this.breaking ? "break[" : "do[") + this.sink.getSinks()[0] + "]";
        }
    }
}

