/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.runtime.rule;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.core.command.impl.NotTransactionalCommand;
import org.drools.core.fluent.impl.Batch;
import org.drools.core.fluent.impl.BatchImpl;
import org.drools.core.fluent.impl.InternalExecutable;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;

public class InternalExecutableTest {
    @Test
    public void notTransactionalCommandTest() {
        BatchImpl batch = new BatchImpl();
        batch.addCommand((Command)new TransactionalCommandTest());
        batch.addCommand((Command)new NotTransactionalCommandTest());
        InternalExecutableImplTest internalExecutableImplTest = new InternalExecutableImplTest(new Batch[]{batch});
        Assertions.assertThat((boolean)internalExecutableImplTest.canRunInTransaction()).isFalse();
    }

    @Test
    public void transactionalCommandTest() {
        BatchImpl batch = new BatchImpl();
        batch.addCommand((Command)new TransactionalCommandTest());
        batch.addCommand((Command)new TransactionalCommandTest());
        InternalExecutableImplTest internalExecutableImplTest = new InternalExecutableImplTest(new Batch[]{batch});
        Assertions.assertThat((boolean)internalExecutableImplTest.canRunInTransaction()).isTrue();
    }

    @Test
    public void emptyCommandTest() {
        BatchImpl batch = new BatchImpl();
        InternalExecutableImplTest internalExecutableImplTest = new InternalExecutableImplTest(new Batch[]{batch});
        Assertions.assertThat((boolean)internalExecutableImplTest.canRunInTransaction()).isTrue();
    }

    class InternalExecutableImplTest
    implements InternalExecutable {
        private final List<Batch> batches;

        public List<Batch> getBatches() {
            return this.batches;
        }

        InternalExecutableImplTest(Batch ... batches) {
            this.batches = Arrays.asList(batches);
        }
    }

    class NotTransactionalCommandTest
    implements NotTransactionalCommand<Void> {
        NotTransactionalCommandTest() {
        }

        public Void execute(Context context) {
            return null;
        }
    }

    class TransactionalCommandTest
    implements ExecutableCommand<Void> {
        TransactionalCommandTest() {
        }

        public Void execute(Context context) {
            return null;
        }
    }
}

