/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.facttemplates;

import org.assertj.core.api.Assertions;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.facttemplates.Fact;
import org.drools.core.facttemplates.FactTemplateImpl;
import org.drools.core.facttemplates.FieldTemplate;
import org.drools.core.facttemplates.FieldTemplateImpl;
import org.junit.Test;

public class FactTemplateTest {
    @Test
    public void testFieldsAndGetters() {
        KnowledgePackageImpl pkg = new KnowledgePackageImpl("org.store");
        FieldTemplateImpl cheeseName = new FieldTemplateImpl("name", 0, String.class);
        FieldTemplateImpl cheesePrice = new FieldTemplateImpl("price", 1, Integer.class);
        FieldTemplate[] fields = new FieldTemplate[]{cheeseName, cheesePrice};
        FactTemplateImpl cheese = new FactTemplateImpl((InternalKnowledgePackage)pkg, "Cheese", fields);
        Assertions.assertThat((String)cheese.getPackage().getName()).isEqualTo("org.store");
        Assertions.assertThat((String)cheese.getName()).isEqualTo("Cheese");
        Assertions.assertThat((int)cheese.getNumberOfFields()).isEqualTo(2);
        Assertions.assertThat((Object)cheese.getFieldTemplate("name")).isSameAs((Object)cheeseName);
        Assertions.assertThat((Object)cheese.getFieldTemplate("price")).isSameAs((Object)cheesePrice);
        Assertions.assertThat((int)cheese.getFieldTemplateIndex("name")).isEqualTo(0);
        Assertions.assertThat((int)cheese.getFieldTemplateIndex("price")).isEqualTo(1);
    }

    @Test
    public void testEqualsAndHashCode() {
        KnowledgePackageImpl pkg = new KnowledgePackageImpl("org.store");
        FieldTemplateImpl cheeseName = new FieldTemplateImpl("name", 0, String.class);
        FieldTemplateImpl cheesePrice = new FieldTemplateImpl("price", 1, Integer.class);
        FieldTemplate[] fields1 = new FieldTemplate[]{cheeseName, cheesePrice};
        FactTemplateImpl cheese1 = new FactTemplateImpl((InternalKnowledgePackage)pkg, "Cheese", fields1);
        FieldTemplateImpl cheeseType = new FieldTemplateImpl("type", 0, String.class);
        FieldTemplate[] fields2 = new FieldTemplate[]{cheeseType, cheesePrice};
        FactTemplateImpl cheese2 = new FactTemplateImpl((InternalKnowledgePackage)pkg, "Cheese", fields2);
        Assertions.assertThat((Object)cheese1).isNotSameAs((Object)cheese2);
        Assertions.assertThat((Object)cheese1).isNotEqualTo((Object)cheese2);
        Assertions.assertThat((int)cheese1.hashCode()).isNotEqualTo(cheese2.hashCode());
        FieldTemplateImpl cheeseName2 = new FieldTemplateImpl("name", 0, String.class);
        FieldTemplateImpl cheesePrice2 = new FieldTemplateImpl("price", 1, Integer.class);
        FieldTemplate[] fields3 = new FieldTemplate[]{cheeseName2, cheesePrice2};
        FactTemplateImpl cheese3 = new FactTemplateImpl((InternalKnowledgePackage)pkg, "Cheese", fields3);
        Assertions.assertThat((Object)cheese1).isNotSameAs((Object)cheese3);
        Assertions.assertThat((Object)cheese3).isEqualTo((Object)cheese1);
        Assertions.assertThat((int)cheese3.hashCode()).isEqualTo(cheese1.hashCode());
    }

    @Test
    public void testFacts() {
        KnowledgePackageImpl pkg = new KnowledgePackageImpl("org.store");
        FieldTemplateImpl cheeseName = new FieldTemplateImpl("name", 0, String.class);
        FieldTemplateImpl cheesePrice = new FieldTemplateImpl("price", 1, Integer.class);
        FieldTemplate[] fields1 = new FieldTemplate[]{cheeseName, cheesePrice};
        FactTemplateImpl cheese1 = new FactTemplateImpl((InternalKnowledgePackage)pkg, "Cheese", fields1);
        Fact stilton1 = cheese1.createFact(10L);
        stilton1.setFieldValue("name", (Object)"stilton");
        stilton1.setFieldValue("price", (Object)new Integer(200));
        Fact stilton2 = cheese1.createFact(11L);
        stilton2.setFieldValue(0, (Object)"stilton");
        stilton2.setFieldValue(1, (Object)new Integer(200));
        Assertions.assertThat((Object)stilton2).isEqualTo((Object)stilton1);
        Assertions.assertThat((int)stilton2.hashCode()).isEqualTo(stilton1.hashCode());
        Fact brie = cheese1.createFact(12L);
        brie.setFieldValue("name", (Object)"brie");
        brie.setFieldValue("price", (Object)new Integer(55));
        Assertions.assertThat((Object)stilton1).isNotEqualTo((Object)brie);
        Assertions.assertThat((int)stilton1.hashCode()).isNotEqualTo(brie.hashCode());
    }
}

