/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import org.assertj.core.api.Assertions;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.MockTupleSource;
import org.drools.core.reteoo.QueryElementNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.QueryArgument;
import org.drools.core.rule.QueryElement;
import org.drools.core.spi.PropagationContext;
import org.drools.core.test.model.DroolsTestCase;
import org.junit.Before;
import org.junit.Test;

public class QueryElementNodeTest
extends DroolsTestCase {
    private PropagationContext context;
    private StatefulKnowledgeSessionImpl workingMemory;
    private InternalKnowledgeBase kBase;
    private BuildContext buildContext;

    @Before
    public void setUp() {
        this.kBase = KnowledgeBaseFactory.newKnowledgeBase();
        this.buildContext = new BuildContext(this.kBase);
        this.buildContext.setRule(new RuleImpl());
        PropagationContextFactory pctxFactory = this.kBase.getConfiguration().getComponentFactory().getPropagationContextFactory();
        this.context = pctxFactory.createPropagationContext(0L, PropagationContext.Type.INSERTION, null, null, null);
        this.workingMemory = new InstrumentedWorkingMemory(0, this.kBase);
    }

    @Test
    public void testAttach() throws Exception {
        QueryElement queryElement = new QueryElement(null, null, new QueryArgument[0], null, null, false, false);
        MockTupleSource source = new MockTupleSource(12, this.buildContext);
        QueryElementNode node = new QueryElementNode(18, (LeftTupleSource)source, queryElement, true, false, this.buildContext);
        Assertions.assertThat((int)node.getId()).isEqualTo(18);
        Assertions.assertThat((int)source.getAttached()).isEqualTo(0);
        node.attach(this.buildContext);
        Assertions.assertThat((int)source.getAttached()).isEqualTo(1);
    }

    public static class InstrumentedWorkingMemory
    extends StatefulKnowledgeSessionImpl {
        public InstrumentedWorkingMemory(int id, InternalKnowledgeBase kBase) {
            super(new Long(id).longValue(), kBase);
        }
    }
}

