/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.lang.reflect.Field;
import org.assertj.core.api.Assertions;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.reteoo.CompositeLeftTupleSinkAdapter;
import org.drools.core.reteoo.EmptyLeftTupleSinkAdapter;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkPropagator;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.MockLeftTupleSink;
import org.drools.core.reteoo.MockTupleSource;
import org.drools.core.reteoo.SingleLeftTupleSinkAdapter;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.test.model.DroolsTestCase;
import org.junit.Test;
import org.kie.api.KieBaseConfiguration;

public class TupleSourceTest
extends DroolsTestCase {
    @Test
    public void testObjectTupleConstructor() {
        KieBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)kconf);
        BuildContext buildContext = new BuildContext(kBase);
        MockTupleSource source = new MockTupleSource(15, buildContext);
        Assertions.assertThat((int)source.getId()).isEqualTo(15);
    }

    @Test
    public void testAddTupleSink() throws Exception {
        KieBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)kconf);
        BuildContext buildContext = new BuildContext(kBase);
        MockTupleSource source = new MockTupleSource(15, buildContext);
        Field field = LeftTupleSource.class.getDeclaredField("sink");
        field.setAccessible(true);
        LeftTupleSinkPropagator sink = (LeftTupleSinkPropagator)field.get((Object)source);
        Assertions.assertThat((Object)sink).isSameAs((Object)EmptyLeftTupleSinkAdapter.getInstance());
        MockLeftTupleSink sink1 = new MockLeftTupleSink(buildContext);
        source.addTupleSink((LeftTupleSink)sink1);
        sink = (LeftTupleSinkPropagator)field.get((Object)source);
        Assertions.assertThat((Object)sink).isInstanceOf(SingleLeftTupleSinkAdapter.class);
        Assertions.assertThat((Object[])sink.getSinks()).hasSize(1);
        MockLeftTupleSink sink2 = new MockLeftTupleSink(buildContext);
        source.addTupleSink((LeftTupleSink)sink2);
        sink = (LeftTupleSinkPropagator)field.get((Object)source);
        Assertions.assertThat((Object)sink).isInstanceOf(CompositeLeftTupleSinkAdapter.class);
        Assertions.assertThat((Object[])sink.getSinks()).hasSize(2);
        MockLeftTupleSink sink3 = new MockLeftTupleSink(buildContext);
        source.addTupleSink((LeftTupleSink)sink3);
        Assertions.assertThat((Object)sink).isInstanceOf(CompositeLeftTupleSinkAdapter.class);
        Assertions.assertThat((Object[])sink.getSinks()).hasSize(3);
        source.removeTupleSink((LeftTupleSink)sink2);
        Assertions.assertThat((Object)sink).isInstanceOf(CompositeLeftTupleSinkAdapter.class);
        Assertions.assertThat((Object[])sink.getSinks()).hasSize(2);
        source.removeTupleSink((LeftTupleSink)sink1);
        sink = (LeftTupleSinkPropagator)field.get((Object)source);
        Assertions.assertThat((Object)sink).isInstanceOf(SingleLeftTupleSinkAdapter.class);
        Assertions.assertThat((Object[])sink.getSinks()).hasSize(1);
        source.removeTupleSink((LeftTupleSink)sink3);
        sink = (LeftTupleSinkPropagator)field.get((Object)source);
        Assertions.assertThat((Object)sink).isSameAs((Object)EmptyLeftTupleSinkAdapter.getInstance());
        Assertions.assertThat((Object[])sink.getSinks()).hasSize(0);
    }
}

