/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.spi;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.spi.ProcessContext;
import org.junit.Test;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.CaseAssignment;
import org.kie.api.runtime.process.CaseData;
import org.kie.api.task.model.OrganizationalEntity;

public class ProcessContextTest {
    @Test
    public void testProcessContextGetAssignment() {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KieSession ksession = kbase.newKieSession();
        Assertions.assertThat((Object)ksession).isNotNull();
        CaseInformation caseInfo = new CaseInformation();
        caseInfo.assign("owner", new OrganizationalEntity(){

            public String getId() {
                return "testUser";
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }
        });
        ksession.insert((Object)caseInfo);
        ProcessContext processContext = new ProcessContext((KieRuntime)ksession);
        CaseAssignment caseAssignment = processContext.getCaseAssignment();
        Assertions.assertThat((Object)caseAssignment).isNotNull();
        Collection forRole = caseAssignment.getAssignments("owner");
        Assertions.assertThat((Iterable)forRole).isNotNull();
        Assertions.assertThat((int)forRole.size()).isEqualTo(1);
    }

    @Test
    public void testProcessContextGetData() {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KieSession ksession = kbase.newKieSession();
        Assertions.assertThat((Object)ksession).isNotNull();
        CaseInformation caseInfo = new CaseInformation();
        caseInfo.add("test", "value");
        ksession.insert((Object)caseInfo);
        ProcessContext processContext = new ProcessContext((KieRuntime)ksession);
        CaseData caseData = processContext.getCaseData();
        Assertions.assertThat((Object)caseData).isNotNull();
        Map allData = caseData.getData();
        Assertions.assertThat((Map)allData).isNotNull();
        Assertions.assertThat((int)allData.size()).isEqualTo(1);
        Assertions.assertThat((Object)caseData.getData("test")).isEqualTo((Object)"value");
    }

    @Test
    public void testProcessContextGetDataAndAssignmentWithoutInsert() {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KieSession ksession = kbase.newKieSession();
        Assertions.assertThat((Object)ksession).isNotNull();
        ProcessContext processContext = new ProcessContext((KieRuntime)ksession);
        CaseData caseData = processContext.getCaseData();
        Assertions.assertThat((Object)caseData).isNull();
        CaseAssignment caseAssignment = processContext.getCaseAssignment();
        Assertions.assertThat((Object)caseAssignment).isNull();
    }

    private class CaseInformation
    implements CaseData,
    CaseAssignment {
        private String definitionId;
        private Map<String, Object> data = new HashMap<String, Object>();
        private Map<String, OrganizationalEntity> assignment = new HashMap<String, OrganizationalEntity>();

        private CaseInformation() {
        }

        public void assign(String roleName, OrganizationalEntity entity) {
            this.assignment.put(roleName, entity);
        }

        public void assignUser(String roleName, String userId) {
        }

        public void assignGroup(String roleName, String groupId) {
        }

        public void remove(String roleName, OrganizationalEntity entity) {
            this.assignment.remove(roleName);
        }

        public Collection<OrganizationalEntity> getAssignments(String roleName) {
            OrganizationalEntity entity = this.assignment.get(roleName);
            if (entity == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(entity);
        }

        public Collection<String> getRoles() {
            return this.assignment.keySet();
        }

        public Map<String, Object> getData() {
            return this.data;
        }

        public Object getData(String name) {
            return this.data.get(name);
        }

        public void add(String name, Object data) {
            this.data.put(name, data);
        }

        public void remove(String name) {
            this.data.remove(name);
        }

        public String getDefinitionId() {
            return this.definitionId;
        }
    }
}

