/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.index;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.assertj.core.api.AbstractBooleanArrayAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.base.ValueType;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.rule.ContextEntry;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.IndexableConstraint;
import org.drools.core.spi.BetaNodeFieldConstraint;
import org.drools.core.spi.Constraint;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.Tuple;
import org.drools.core.spi.TupleValueExtractor;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.index.IndexUtil;
import org.drools.core.util.index.TupleIndexHashTable;
import org.drools.core.util.index.TupleList;
import org.junit.Test;
import org.kie.internal.conf.IndexPrecedenceOption;

public class IndexUtilTest {
    @Test
    public void isEqualIndexable() {
        FakeBetaNodeFieldConstraint intEqualsConstraint = new FakeBetaNodeFieldConstraint(IndexUtil.ConstraintType.EQUAL, new FakeInternalReadAccessor(ValueType.PINTEGER_TYPE));
        Assertions.assertThat((boolean)IndexUtil.isEqualIndexable((BetaNodeFieldConstraint)intEqualsConstraint)).isTrue();
        FakeBetaNodeFieldConstraint intLessThanConstraint = new FakeBetaNodeFieldConstraint(IndexUtil.ConstraintType.LESS_THAN, new FakeInternalReadAccessor(ValueType.PINTEGER_TYPE));
        Assertions.assertThat((boolean)IndexUtil.isEqualIndexable((BetaNodeFieldConstraint)intLessThanConstraint)).isFalse();
        FakeBetaNodeFieldConstraint bigDecimalEqualsConstraint = new FakeBetaNodeFieldConstraint(IndexUtil.ConstraintType.EQUAL, new FakeInternalReadAccessor(ValueType.BIG_DECIMAL_TYPE));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)IndexUtil.isEqualIndexable((BetaNodeFieldConstraint)bigDecimalEqualsConstraint)).as("BigDecimal equality cannot be indexed because of scale", new Object[0])).isFalse();
    }

    @Test
    public void createBetaMemoryWithIntEquals_shouldBeTupleIndexHashTable() {
        RuleBaseConfiguration config = new RuleBaseConfiguration();
        FakeBetaNodeFieldConstraint intEqualsConstraint = new FakeBetaNodeFieldConstraint(IndexUtil.ConstraintType.EQUAL, new FakeInternalReadAccessor(ValueType.PINTEGER_TYPE));
        BetaMemory betaMemory = IndexUtil.Factory.createBetaMemory((RuleBaseConfiguration)config, (short)181, (BetaNodeFieldConstraint[])new BetaNodeFieldConstraint[]{intEqualsConstraint});
        Assertions.assertThat((Object)betaMemory.getLeftTupleMemory()).isInstanceOf(TupleIndexHashTable.class);
        Assertions.assertThat((Object)betaMemory.getRightTupleMemory()).isInstanceOf(TupleIndexHashTable.class);
    }

    @Test
    public void createBetaMemoryWithBigDecimalEquals_shouldNotBeTupleIndexHashTable() {
        RuleBaseConfiguration config = new RuleBaseConfiguration();
        FakeBetaNodeFieldConstraint bigDecimalEqualsConstraint = new FakeBetaNodeFieldConstraint(IndexUtil.ConstraintType.EQUAL, new FakeInternalReadAccessor(ValueType.BIG_DECIMAL_TYPE));
        BetaMemory betaMemory = IndexUtil.Factory.createBetaMemory((RuleBaseConfiguration)config, (short)181, (BetaNodeFieldConstraint[])new BetaNodeFieldConstraint[]{bigDecimalEqualsConstraint});
        Assertions.assertThat((Object)betaMemory.getLeftTupleMemory()).isInstanceOf(TupleList.class);
        Assertions.assertThat((Object)betaMemory.getRightTupleMemory()).isInstanceOf(TupleList.class);
    }

    @Test
    public void createBetaMemoryWithBigDecimalEqualsAndOtherIndexableConstraints_shouldBeTupleIndexHashTableButBigDecimalIsNotIndexed() {
        RuleBaseConfiguration config = new RuleBaseConfiguration();
        FakeBetaNodeFieldConstraint intEqualsConstraint = new FakeBetaNodeFieldConstraint(IndexUtil.ConstraintType.EQUAL, new FakeInternalReadAccessor(ValueType.PINTEGER_TYPE));
        FakeBetaNodeFieldConstraint bigDecimalEqualsConstraint = new FakeBetaNodeFieldConstraint(IndexUtil.ConstraintType.EQUAL, new FakeInternalReadAccessor(ValueType.BIG_DECIMAL_TYPE));
        FakeBetaNodeFieldConstraint stringEqualsConstraint = new FakeBetaNodeFieldConstraint(IndexUtil.ConstraintType.EQUAL, new FakeInternalReadAccessor(ValueType.STRING_TYPE));
        BetaMemory betaMemory = IndexUtil.Factory.createBetaMemory((RuleBaseConfiguration)config, (short)181, (BetaNodeFieldConstraint[])new BetaNodeFieldConstraint[]{intEqualsConstraint, bigDecimalEqualsConstraint, stringEqualsConstraint});
        Assertions.assertThat((Object)betaMemory.getLeftTupleMemory()).isInstanceOf(TupleIndexHashTable.class);
        AbstractHashTable.Index leftIndex = ((TupleIndexHashTable)betaMemory.getLeftTupleMemory()).getIndex();
        Assertions.assertThat((Object)leftIndex).isInstanceOf(AbstractHashTable.DoubleCompositeIndex.class);
        AbstractHashTable.FieldIndex leftFieldIndex0 = leftIndex.getFieldIndex(0);
        Assertions.assertThat((Comparable)leftFieldIndex0.getLeftExtractor().getValueType()).isEqualTo((Object)ValueType.PINTEGER_TYPE);
        AbstractHashTable.FieldIndex leftFieldIndex1 = leftIndex.getFieldIndex(1);
        Assertions.assertThat((Comparable)leftFieldIndex1.getLeftExtractor().getValueType()).isEqualTo((Object)ValueType.STRING_TYPE);
        Assertions.assertThat((Object)betaMemory.getRightTupleMemory()).isInstanceOf(TupleIndexHashTable.class);
        AbstractHashTable.Index rightIndex = ((TupleIndexHashTable)betaMemory.getRightTupleMemory()).getIndex();
        Assertions.assertThat((Object)rightIndex).isInstanceOf(AbstractHashTable.DoubleCompositeIndex.class);
        AbstractHashTable.FieldIndex rightFieldIndex0 = rightIndex.getFieldIndex(0);
        Assertions.assertThat((Comparable)rightFieldIndex0.getRightExtractor().getValueType()).isEqualTo((Object)ValueType.PINTEGER_TYPE);
        AbstractHashTable.FieldIndex rightFieldIndex1 = rightIndex.getFieldIndex(1);
        Assertions.assertThat((Comparable)rightFieldIndex1.getRightExtractor().getValueType()).isEqualTo((Object)ValueType.STRING_TYPE);
    }

    @Test
    public void isIndexableForNodeWithIntAndString() {
        RuleBaseConfiguration config = new RuleBaseConfiguration();
        FakeBetaNodeFieldConstraint intEqualsConstraint = new FakeBetaNodeFieldConstraint(IndexUtil.ConstraintType.EQUAL, new FakeInternalReadAccessor(ValueType.PINTEGER_TYPE));
        FakeBetaNodeFieldConstraint stringEqualsConstraint = new FakeBetaNodeFieldConstraint(IndexUtil.ConstraintType.EQUAL, new FakeInternalReadAccessor(ValueType.STRING_TYPE));
        BetaNodeFieldConstraint[] constraints = new FakeBetaNodeFieldConstraint[]{intEqualsConstraint, stringEqualsConstraint};
        boolean[] indexed = IndexUtil.isIndexableForNode((IndexPrecedenceOption)IndexPrecedenceOption.EQUALITY_PRIORITY, (short)181, (int)config.getCompositeKeyDepth(), (BetaNodeFieldConstraint[])constraints, (RuleBaseConfiguration)config);
        Assertions.assertThat((boolean[])indexed).containsExactly(new boolean[]{true, true});
    }

    @Test
    public void isIndexableForNodeWithIntAndBigDecimalAndString() {
        RuleBaseConfiguration config = new RuleBaseConfiguration();
        FakeBetaNodeFieldConstraint intEqualsConstraint = new FakeBetaNodeFieldConstraint(IndexUtil.ConstraintType.EQUAL, new FakeInternalReadAccessor(ValueType.PINTEGER_TYPE));
        FakeBetaNodeFieldConstraint bigDecimalEqualsConstraint = new FakeBetaNodeFieldConstraint(IndexUtil.ConstraintType.EQUAL, new FakeInternalReadAccessor(ValueType.BIG_DECIMAL_TYPE));
        FakeBetaNodeFieldConstraint stringEqualsConstraint = new FakeBetaNodeFieldConstraint(IndexUtil.ConstraintType.EQUAL, new FakeInternalReadAccessor(ValueType.STRING_TYPE));
        BetaNodeFieldConstraint[] constraints = new FakeBetaNodeFieldConstraint[]{intEqualsConstraint, bigDecimalEqualsConstraint, stringEqualsConstraint};
        boolean[] indexed = IndexUtil.isIndexableForNode((IndexPrecedenceOption)IndexPrecedenceOption.EQUALITY_PRIORITY, (short)181, (int)config.getCompositeKeyDepth(), (BetaNodeFieldConstraint[])constraints, (RuleBaseConfiguration)config);
        ((AbstractBooleanArrayAssert)Assertions.assertThat((boolean[])indexed).as("BigDecimal is sorted to the last", new Object[0])).containsExactly(new boolean[]{true, true, false});
    }

    @Test
    public void isIndexableForNodeWithBigDecimal() {
        RuleBaseConfiguration config = new RuleBaseConfiguration();
        FakeBetaNodeFieldConstraint bigDecimalEqualsConstraint = new FakeBetaNodeFieldConstraint(IndexUtil.ConstraintType.EQUAL, new FakeInternalReadAccessor(ValueType.BIG_DECIMAL_TYPE));
        BetaNodeFieldConstraint[] constraints = new FakeBetaNodeFieldConstraint[]{bigDecimalEqualsConstraint};
        boolean[] indexed = IndexUtil.isIndexableForNode((IndexPrecedenceOption)IndexPrecedenceOption.EQUALITY_PRIORITY, (short)181, (int)config.getCompositeKeyDepth(), (BetaNodeFieldConstraint[])constraints, (RuleBaseConfiguration)config);
        ((AbstractBooleanArrayAssert)Assertions.assertThat((boolean[])indexed).as("BigDecimal is not indexed", new Object[0])).containsExactly(new boolean[]{false});
    }

    static class FakeInternalReadAccessor
    implements InternalReadAccessor {
        private final ValueType valueType;

        private FakeInternalReadAccessor(ValueType valueType) {
            this.valueType = valueType;
        }

        public Object getValue(Object object) {
            return null;
        }

        public BigDecimal getBigDecimalValue(Object object) {
            return null;
        }

        public BigInteger getBigIntegerValue(Object object) {
            return null;
        }

        public char getCharValue(Object object) {
            return '\u0000';
        }

        public int getIntValue(Object object) {
            return 0;
        }

        public byte getByteValue(Object object) {
            return 0;
        }

        public short getShortValue(Object object) {
            return 0;
        }

        public long getLongValue(Object object) {
            return 0L;
        }

        public float getFloatValue(Object object) {
            return 0.0f;
        }

        public double getDoubleValue(Object object) {
            return 0.0;
        }

        public boolean getBooleanValue(Object object) {
            return false;
        }

        public boolean isNullValue(Object object) {
            return false;
        }

        public ValueType getValueType() {
            return this.valueType;
        }

        public Class<?> getExtractToClass() {
            return null;
        }

        public String getExtractToClassName() {
            return null;
        }

        public Method getNativeReadMethod() {
            return null;
        }

        public String getNativeReadMethodName() {
            return null;
        }

        public int getHashCode(Object object) {
            return 0;
        }

        public int getIndex() {
            return 0;
        }

        public Object getValue(InternalWorkingMemory workingMemory, Object object) {
            return null;
        }

        public BigDecimal getBigDecimalValue(InternalWorkingMemory workingMemory, Object object) {
            return null;
        }

        public BigInteger getBigIntegerValue(InternalWorkingMemory workingMemory, Object object) {
            return null;
        }

        public char getCharValue(InternalWorkingMemory workingMemory, Object object) {
            return '\u0000';
        }

        public int getIntValue(InternalWorkingMemory workingMemory, Object object) {
            return 0;
        }

        public byte getByteValue(InternalWorkingMemory workingMemory, Object object) {
            return 0;
        }

        public short getShortValue(InternalWorkingMemory workingMemory, Object object) {
            return 0;
        }

        public long getLongValue(InternalWorkingMemory workingMemory, Object object) {
            return 0L;
        }

        public float getFloatValue(InternalWorkingMemory workingMemory, Object object) {
            return 0.0f;
        }

        public double getDoubleValue(InternalWorkingMemory workingMemory, Object object) {
            return 0.0;
        }

        public boolean getBooleanValue(InternalWorkingMemory workingMemory, Object object) {
            return false;
        }

        public boolean isNullValue(InternalWorkingMemory workingMemory, Object object) {
            return false;
        }

        public int getHashCode(InternalWorkingMemory workingMemory, Object object) {
            return 0;
        }

        public boolean isGlobal() {
            return false;
        }

        public boolean isSelfReference() {
            return false;
        }
    }

    static class FakeBetaNodeFieldConstraint
    implements BetaNodeFieldConstraint,
    IndexableConstraint {
        private IndexUtil.ConstraintType constraintType;
        private InternalReadAccessor fieldExtractor;

        public FakeBetaNodeFieldConstraint() {
        }

        public FakeBetaNodeFieldConstraint(IndexUtil.ConstraintType constraintType, InternalReadAccessor fieldExtractor) {
            this.constraintType = constraintType;
            this.fieldExtractor = fieldExtractor;
        }

        public Declaration[] getRequiredDeclarations() {
            return null;
        }

        public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
        }

        public Constraint clone() {
            return null;
        }

        public Constraint.ConstraintType getType() {
            return null;
        }

        public boolean isTemporal() {
            return false;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public boolean isAllowedCachedLeft(ContextEntry context, InternalFactHandle handle) {
            return false;
        }

        public boolean isAllowedCachedRight(Tuple tuple, ContextEntry context) {
            return false;
        }

        public ContextEntry createContextEntry() {
            return null;
        }

        public BetaNodeFieldConstraint cloneIfInUse() {
            return null;
        }

        public boolean isUnification() {
            return false;
        }

        public boolean isIndexable(short nodeType, RuleBaseConfiguration config) {
            return false;
        }

        public IndexUtil.ConstraintType getConstraintType() {
            return this.constraintType;
        }

        public FieldValue getField() {
            return null;
        }

        public AbstractHashTable.FieldIndex getFieldIndex() {
            return new AbstractHashTable.FieldIndex(this.fieldExtractor, (TupleValueExtractor)new Declaration("$p1", this.fieldExtractor, null));
        }

        public InternalReadAccessor getFieldExtractor() {
            return this.fieldExtractor;
        }

        public TupleValueExtractor getIndexExtractor() {
            return null;
        }
    }
}

