/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command;

import java.util.function.Supplier;
import org.drools.core.command.impl.ExecutableCommand;
import org.drools.core.command.impl.RegistryContext;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.rule.RuleUnit;
import org.kie.api.runtime.rule.RuleUnitExecutor;

public class RunUnitCommand<T extends RuleUnit>
implements ExecutableCommand<Integer> {
    private static final long serialVersionUID = 626194815589613487L;
    private Class<T> unitClass;
    private Supplier<T> unitSupplier;

    public RunUnitCommand(Class<T> unitClass) {
        this.unitClass = unitClass;
    }

    public RunUnitCommand(Supplier<T> unitSupplier) {
        this.unitSupplier = unitSupplier;
    }

    @Override
    public Integer execute(Context context) {
        int firedRules;
        RuleUnitExecutor ruleUnitExecutor = ((RegistryContext)context).lookup(RuleUnitExecutor.class);
        if (ruleUnitExecutor == null) {
            throw new IllegalStateException("RuleUnitExecutor si not present in the Registry");
        }
        if (this.unitClass != null) {
            firedRules = ruleUnitExecutor.run(this.unitClass);
        } else if (this.unitSupplier != null) {
            firedRules = ruleUnitExecutor.run((RuleUnit)this.unitSupplier.get());
        } else {
            throw new IllegalStateException("State is inconsistent because there is no unitClass nor unitSupplier");
        }
        return firedRules;
    }

    public String toString() {
        return "RunUnitCommand{unitClass='" + this.unitClass + '\'' + ", unitSupplier=" + this.unitSupplier + '}';
    }
}

