/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.drools.core.SessionConfiguration;
import org.drools.core.base.MapGlobalResolver;
import org.drools.core.command.impl.ContextImpl;
import org.drools.core.command.impl.ExecutableCommand;
import org.drools.core.command.impl.RegistryContext;
import org.drools.core.command.runtime.BatchExecutionCommandImpl;
import org.drools.core.command.runtime.rule.FireAllRulesCommand;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.impl.AbstractRuntime;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.management.DroolsManagementAgent;
import org.drools.core.runtime.impl.ExecutionResultImpl;
import org.kie.api.KieBase;
import org.kie.api.command.BatchExecutionCommand;
import org.kie.api.command.Command;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.Channel;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.Globals;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.internal.runtime.StatelessKnowledgeSession;

public class StatelessKnowledgeSessionImpl
extends AbstractRuntime
implements StatelessKnowledgeSession,
StatelessKieSession {
    private InternalKnowledgeBase kBase;
    private MapGlobalResolver sessionGlobals = new MapGlobalResolver();
    private Map<String, Channel> channels = new HashMap<String, Channel>();
    private final List<ListnerHolder> listeners = new CopyOnWriteArrayList<ListnerHolder>();
    private KieSessionConfiguration conf;
    private Environment environment;
    private AtomicBoolean mbeanRegistered = new AtomicBoolean(false);
    private DroolsManagementAgent.CBSKey mbeanRegisteredCBSKey;
    private AtomicLong wmCreated = new AtomicLong(0L);

    public StatelessKnowledgeSessionImpl() {
    }

    public StatelessKnowledgeSessionImpl(InternalKnowledgeBase kBase, KieSessionConfiguration conf) {
        this.kBase = kBase;
        this.conf = conf != null ? conf : kBase.getSessionConfiguration();
        this.environment = EnvironmentFactory.newEnvironment();
    }

    public InternalKnowledgeBase getKnowledgeBase() {
        return this.kBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatefulKnowledgeSession newWorkingMemory() {
        this.kBase.readLock();
        try {
            StatefulKnowledgeSessionImpl ksession = ((KnowledgeBaseImpl)this.kBase).internalCreateStatefulKnowledgeSession(this.environment, (SessionConfiguration)this.conf).setStateless(true);
            ((Globals)ksession.getGlobalResolver()).setDelegate((Globals)this.sessionGlobals);
            this.registerListeners(ksession);
            for (Map.Entry<String, Channel> entry : this.channels.entrySet()) {
                ksession.registerChannel(entry.getKey(), entry.getValue());
            }
            this.wmCreated.incrementAndGet();
            StatefulKnowledgeSessionImpl statefulKnowledgeSessionImpl = ksession;
            return statefulKnowledgeSessionImpl;
        }
        finally {
            this.kBase.readUnlock();
        }
    }

    public void initMBeans(String containerId, String kbaseId, String ksessionName) {
        if (this.kBase.getConfiguration() != null && this.kBase.getConfiguration().isMBeansEnabled() && this.mbeanRegistered.compareAndSet(false, true)) {
            this.mbeanRegisteredCBSKey = new DroolsManagementAgent.CBSKey(containerId, kbaseId, ksessionName);
            DroolsManagementAgent.getInstance().registerKnowledgeSessionUnderName(this.mbeanRegisteredCBSKey, this);
        }
    }

    public long getWorkingMemoryCreatec() {
        return this.wmCreated.get();
    }

    private void registerListeners(StatefulKnowledgeSessionImpl wm) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (ListnerHolder listnerHolder : this.listeners) {
            switch (listnerHolder.type) {
                case AGENDA: {
                    wm.addEventListener((AgendaEventListener)listnerHolder.listener);
                    break;
                }
                case RUNTIME: {
                    wm.addEventListener((RuleRuntimeEventListener)listnerHolder.listener);
                    break;
                }
                case PROCESS: {
                    wm.addEventListener((ProcessEventListener)listnerHolder.listener);
                }
            }
        }
    }

    public void addEventListener(AgendaEventListener listener) {
        this.listeners.add(new ListnerHolder(ListnerHolder.Type.AGENDA, (EventListener)listener));
    }

    public Collection<AgendaEventListener> getAgendaEventListeners() {
        return this.getListeners(ListnerHolder.Type.AGENDA);
    }

    public void removeEventListener(AgendaEventListener listener) {
        this.listeners.remove(new ListnerHolder(ListnerHolder.Type.AGENDA, (EventListener)listener));
    }

    public void addEventListener(RuleRuntimeEventListener listener) {
        this.listeners.add(new ListnerHolder(ListnerHolder.Type.RUNTIME, (EventListener)listener));
    }

    public void removeEventListener(RuleRuntimeEventListener listener) {
        this.listeners.remove(new ListnerHolder(ListnerHolder.Type.RUNTIME, (EventListener)listener));
    }

    public Collection<RuleRuntimeEventListener> getRuleRuntimeEventListeners() {
        return this.getListeners(ListnerHolder.Type.RUNTIME);
    }

    public void addEventListener(ProcessEventListener listener) {
        this.listeners.add(new ListnerHolder(ListnerHolder.Type.PROCESS, (EventListener)listener));
    }

    public Collection<ProcessEventListener> getProcessEventListeners() {
        return this.getListeners(ListnerHolder.Type.PROCESS);
    }

    private Collection<? extends EventListener> getListeners(ListnerHolder.Type type) {
        if (this.listeners.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<EventListener> l = new ArrayList<EventListener>();
        for (ListnerHolder listnerHolder : this.listeners) {
            if (listnerHolder.type != type) continue;
            l.add(listnerHolder.listener);
        }
        return l;
    }

    public void removeEventListener(ProcessEventListener listener) {
        this.listeners.remove(new ListnerHolder(ListnerHolder.Type.RUNTIME, (EventListener)listener));
    }

    public void setGlobal(String identifier, Object value) {
        this.sessionGlobals.setGlobal(identifier, value);
    }

    public Globals getGlobals() {
        return this.sessionGlobals;
    }

    public void registerChannel(String name, Channel channel) {
        this.channels.put(name, channel);
    }

    public void unregisterChannel(String name) {
        this.channels.remove(name);
    }

    public Map<String, Channel> getChannels() {
        return Collections.unmodifiableMap(this.channels);
    }

    public KieBase getKieBase() {
        return this.getKnowledgeBase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(Command<T> command) {
        StatefulKnowledgeSession ksession = this.newWorkingMemory();
        RegistryContext context = new ContextImpl().register(KieSession.class, ksession);
        try {
            Object object;
            if (command instanceof BatchExecutionCommand) {
                context.register(ExecutionResultImpl.class, new ExecutionResultImpl());
            }
            ((StatefulKnowledgeSessionImpl)ksession).startBatchExecution();
            Object o = ((ExecutableCommand)command).execute(context);
            boolean autoFireAllRules = true;
            if (command instanceof FireAllRulesCommand) {
                autoFireAllRules = false;
            } else if (command instanceof BatchExecutionCommandImpl) {
                for (Command nestedCmd : ((BatchExecutionCommandImpl)command).getCommands()) {
                    if (!(nestedCmd instanceof FireAllRulesCommand)) continue;
                    autoFireAllRules = false;
                    break;
                }
            }
            if (autoFireAllRules) {
                ksession.fireAllRules();
            }
            if (command instanceof BatchExecutionCommand) {
                object = context.lookup(ExecutionResultImpl.class);
                return (T)object;
            }
            object = o;
            return (T)object;
        }
        finally {
            ((StatefulKnowledgeSessionImpl)ksession).endBatchExecution();
            this.dispose(ksession);
        }
    }

    public void execute(Object object) {
        StatefulKnowledgeSession ksession = this.newWorkingMemory();
        try {
            ksession.insert(object);
            ksession.fireAllRules();
        }
        finally {
            this.dispose(ksession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Iterable objects) {
        StatefulKnowledgeSession ksession = this.newWorkingMemory();
        try {
            for (Object object : objects) {
                ksession.insert(object);
            }
            ksession.fireAllRules();
        }
        finally {
            this.dispose(ksession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List executeWithResults(Iterable objects, ObjectFilter filter) {
        ArrayList<Object> list = new ArrayList<Object>();
        StatefulKnowledgeSession ksession = this.newWorkingMemory();
        try {
            for (Object object : objects) {
                ksession.insert(object);
            }
            ksession.fireAllRules();
            for (FactHandle fh : ksession.getFactHandles(filter)) {
                list.add(((InternalFactHandle)fh).getObject());
            }
        }
        finally {
            this.dispose(ksession);
        }
        return list;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    protected void dispose(StatefulKnowledgeSession ksession) {
        ksession.dispose();
    }

    private static class ListnerHolder {
        final Type type;
        final EventListener listener;

        private ListnerHolder(Type type, EventListener listener) {
            this.type = type;
            this.listener = listener;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof ListnerHolder)) {
                return false;
            }
            ListnerHolder that = (ListnerHolder)obj;
            return this.type == that.type && this.listener == that.listener;
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.listener.hashCode();
            return result;
        }

        static enum Type {
            AGENDA,
            RUNTIME,
            PROCESS;

        }
    }
}

