/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.drools.core.InitialFact;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.ValueType;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.FactHandleClassStore;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.common.UpdateContext;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.CompositePartitionAwareObjectSinkAdapter;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.WindowNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.EntryPointId;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.PropagationContext;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.JobHandle;
import org.drools.core.util.bitmask.BitMask;
import org.drools.core.util.bitmask.EmptyBitMask;

public class ObjectTypeNode
extends ObjectSource
implements ObjectSink,
MemoryFactory<ObjectTypeNodeMemory> {
    private static final long serialVersionUID = 510L;
    protected ObjectType objectType;
    private boolean objectMemoryEnabled;
    private long expirationOffset = -1L;
    private boolean queryNode;
    private volatile transient boolean dirty;
    protected transient IdGenerator idGenerator;
    public static final Id DEFAULT_ID = new Id(-1, 0);

    public int getOtnIdCounter() {
        return this.idGenerator.otnIdCounter;
    }

    public ObjectTypeNode() {
    }

    public ObjectTypeNode(int id, EntryPointNode source, ObjectType objectType, BuildContext context) {
        super(id, RuleBasePartitionId.MAIN_PARTITION, context.getKnowledgeBase().getConfiguration().isMultithreadEvaluation(), source, context.getKnowledgeBase().getConfiguration().getAlphaNodeHashingThreshold(), context.getKnowledgeBase().getConfiguration().getAlphaNodeRangeIndexThreshold());
        this.objectType = objectType;
        this.idGenerator = new IdGenerator(id);
        this.setObjectMemoryEnabled(context.isObjectTypeNodeMemoryEnabled());
        if (ClassObjectType.DroolsQuery_ObjectType.isAssignableFrom(objectType)) {
            this.queryNode = true;
        }
        this.dirty = true;
        this.hashcode = this.calculateHashCode();
        if (objectType != ClassObjectType.InitialFact_ObjectType && context.getKnowledgeBase().getConfiguration().isMultithreadEvaluation()) {
            this.sink = new CompositePartitionAwareObjectSinkAdapter();
        }
        this.initMemoryId(context);
    }

    @Override
    public short getType() {
        return 30;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    @Override
    public RuleBasePartitionId getPartitionId() {
        return RuleBasePartitionId.MAIN_PARTITION;
    }

    @Override
    public BitMask calculateDeclaredMask(Class modifiedClass, List<String> settableProperties) {
        return EmptyBitMask.get();
    }

    public boolean isAssignableFrom(ObjectType objectType) {
        return this.objectType.isAssignableFrom(objectType);
    }

    public void assertInitialFact(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (this.objectMemoryEnabled) {
            InitialFactObjectTypeNodeMemory memory = (InitialFactObjectTypeNodeMemory)workingMemory.getNodeMemory(this);
            memory.add(factHandle);
        }
        this.checkDirty();
        this.propagateAssert(factHandle, context, workingMemory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkDirty() {
        if (this.dirty) {
            ObjectTypeNode objectTypeNode = this;
            synchronized (objectTypeNode) {
                if (this.dirty) {
                    this.resetIdGenerator();
                    ObjectTypeNode.updateTupleSinkId(this, this);
                    this.dirty = false;
                }
            }
        }
    }

    @Override
    public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
    }

    public void propagateAssert(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        this.checkDirty();
        this.sink.propagateAssertObject(factHandle, context, workingMemory);
    }

    public void retractObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        this.checkDirty();
        ObjectTypeNode.doRetractObject(factHandle, context, workingMemory);
    }

    public void retractObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory, int partition) {
        this.checkDirty();
        ObjectTypeNode.retractRightTuples(factHandle, context, workingMemory, partition);
        ObjectTypeNode.retractLeftTuples(factHandle, context, workingMemory, partition);
    }

    public static void doRetractObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        ObjectTypeNode.retractRightTuples(factHandle, context, workingMemory);
        ObjectTypeNode.retractLeftTuples(factHandle, context, workingMemory);
    }

    public static void expireLeftTuple(LeftTuple leftTuple) {
        if (!leftTuple.isExpired()) {
            leftTuple.setExpired();
            for (LeftTuple child = leftTuple.getFirstChild(); child != null; child = (LeftTuple)child.getHandleNext()) {
                ObjectTypeNode.expireLeftTuple(child);
            }
            for (LeftTuple peer = leftTuple.getPeer(); peer != null; peer = peer.getPeer()) {
                ObjectTypeNode.expireLeftTuple(peer);
            }
        }
    }

    public static void expireRightTuple(RightTuple rightTuple) {
        for (LeftTuple child = rightTuple.getFirstChild(); child != null; child = (LeftTuple)child.getHandleNext()) {
            ObjectTypeNode.expireLeftTuple(child);
        }
    }

    public static void retractLeftTuples(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        factHandle.forEachLeftTuple(lt -> {
            LeftTupleSink sink = (LeftTupleSink)lt.getTupleSink();
            ((LeftInputAdapterNode)sink.getLeftTupleSource()).retractLeftTuple((LeftTuple)lt, context, workingMemory);
        });
        factHandle.clearLeftTuples();
    }

    public static void retractLeftTuples(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory, int partition) {
        DefaultFactHandle.CompositeLinkedTuples linkedTuples = (DefaultFactHandle.CompositeLinkedTuples)factHandle.getLinkedTuples();
        linkedTuples.forEachLeftTuple(partition, lt -> {
            LeftTupleSink sink = (LeftTupleSink)lt.getTupleSink();
            ((LeftInputAdapterNode)sink.getLeftTupleSource()).retractLeftTuple((LeftTuple)lt, context, workingMemory);
        });
        linkedTuples.clearLeftTuples(partition);
    }

    public static void retractRightTuples(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        factHandle.forEachRightTuple(rt -> rt.retractTuple(context, workingMemory));
        factHandle.clearRightTuples();
    }

    public static void retractRightTuples(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory, int partition) {
        DefaultFactHandle.CompositeLinkedTuples linkedTuples = (DefaultFactHandle.CompositeLinkedTuples)factHandle.getLinkedTuples();
        linkedTuples.forEachRightTuple(partition, rt -> rt.retractTuple(context, workingMemory));
        linkedTuples.clearRightTuples(partition);
    }

    protected void resetIdGenerator() {
        this.idGenerator.reset();
    }

    @Override
    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        this.checkDirty();
        this.sink.propagateModifyObject(factHandle, modifyPreviousTuples, context.adaptModificationMaskForObjectType(this.objectType, workingMemory), workingMemory);
    }

    @Override
    public void updateSink(ObjectSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        this.checkDirty();
        ObjectTypeNodeMemory memory = workingMemory.getNodeMemory(this);
        Iterator<InternalFactHandle> it = memory.iterator();
        while (it.hasNext()) {
            sink.assertObject(it.next(), context, workingMemory);
        }
    }

    @Override
    public void doAttach(BuildContext context) {
        super.doAttach(context);
        this.source.addObjectSink(this);
        Class<?> nodeTypeClass = this.objectType.getClassType();
        if (nodeTypeClass == null) {
            return;
        }
        EntryPointNode epn = context.getKnowledgeBase().getRete().getEntryPointNode(((EntryPointNode)this.source).getEntryPoint());
        if (epn == null) {
            return;
        }
        ObjectTypeConf objectTypeConf = epn.getTypeConfReg().getObjectTypeConfByClass(nodeTypeClass);
        if (objectTypeConf != null) {
            objectTypeConf.resetCache();
        }
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.dirty = true;
    }

    protected static void updateTupleSinkId(ObjectTypeNode otn, ObjectSource source) {
        for (ObjectSink sink : source.sink.getSinks()) {
            if (sink instanceof BetaNode) {
                ((BetaNode)sink).setRightInputOtnId(otn.nextOtnId());
                continue;
            }
            if (sink instanceof LeftInputAdapterNode) {
                for (LeftTupleSink liaChildSink : ((LeftInputAdapterNode)sink).getSinkPropagator().getSinks()) {
                    liaChildSink.setLeftInputOtnId(otn.nextOtnId());
                }
                continue;
            }
            if (sink instanceof WindowNode) {
                ((WindowNode)sink).setRightInputOtnId(otn.nextOtnId());
                ObjectTypeNode.updateTupleSinkId(otn, (WindowNode)sink);
                continue;
            }
            if (!(sink instanceof AlphaNode)) continue;
            ObjectTypeNode.updateTupleSinkId(otn, (AlphaNode)sink);
        }
    }

    public Id nextOtnId() {
        return this.idGenerator.nextId();
    }

    @Override
    public boolean remove(RuleRemovalContext context, ReteooBuilder builder) {
        return this.doRemove(context, builder);
    }

    @Override
    protected boolean doRemove(RuleRemovalContext context, ReteooBuilder builder) {
        return false;
    }

    @Override
    public ObjectTypeNodeMemory createMemory(RuleBaseConfiguration config, InternalWorkingMemory wm) {
        Class<?> classType = ((ClassObjectType)this.getObjectType()).getClassType();
        if (InitialFact.class.isAssignableFrom(classType)) {
            return new InitialFactObjectTypeNodeMemory(classType);
        }
        return new ObjectTypeNodeMemory(classType, wm);
    }

    public boolean isObjectMemoryEnabled() {
        return this.objectMemoryEnabled;
    }

    public void setObjectMemoryEnabled(boolean objectMemoryEnabled) {
        this.objectMemoryEnabled = objectMemoryEnabled;
    }

    @Override
    public String toString() {
        return "[ObjectTypeNode(" + this.id + ")::" + ((EntryPointNode)this.source).getEntryPoint() + " objectType=" + this.objectType + " expiration=" + this.getExpirationOffset() + "ms ]";
    }

    private int calculateHashCode() {
        return (this.objectType != null ? this.objectType.hashCode() : 0) * 37 + (this.source != null ? this.source.hashCode() : 0) * 31;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ObjectTypeNode) || this.hashCode() != object.hashCode()) {
            return false;
        }
        ObjectTypeNode other = (ObjectTypeNode)object;
        return this.source.getId() == other.source.getId() && this.objectType.equals(other.objectType);
    }

    public EntryPointId getEntryPoint() {
        return ((EntryPointNode)this.source).getEntryPoint();
    }

    public long getExpirationOffset() {
        return this.expirationOffset;
    }

    public void setExpirationOffset(long expirationOffset) {
        this.expirationOffset = expirationOffset;
        if (!this.objectType.getValueType().equals((Object)ValueType.QUERY_TYPE)) {
            if (expirationOffset > 0L) {
                this.setObjectMemoryEnabled(true);
            } else if (expirationOffset == 0L) {
                this.setObjectMemoryEnabled(false);
            }
        }
    }

    public void mergeExpirationOffset(ObjectTypeNode other) {
        this.setExpirationOffset(this.expirationOffset == -1L || other.expirationOffset == -1L ? -1L : Math.max(this.expirationOffset, other.expirationOffset));
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException("This should never get called, as the PropertyReactive first happens at the AlphaNode");
    }

    public static class InitialFactObjectTypeNodeMemory
    extends ObjectTypeNodeMemory {
        private List<InternalFactHandle> list = Collections.emptyList();

        InitialFactObjectTypeNodeMemory(Class<?> classType) {
            super(classType);
        }

        public void add(InternalFactHandle factHandle) {
            this.list = Collections.singletonList(factHandle);
        }

        @Override
        public Iterator<InternalFactHandle> iterator() {
            return this.list.iterator();
        }

        @Override
        public void reset() {
            this.list = Collections.emptyList();
        }
    }

    public static class ObjectTypeNodeMemory
    implements Memory {
        private FactHandleClassStore store;
        private Class<?> classType;

        ObjectTypeNodeMemory(Class<?> classType) {
            this.classType = classType;
        }

        ObjectTypeNodeMemory(Class<?> classType, InternalWorkingMemory wm) {
            this(classType);
            this.store = wm.getStoreForClass(classType);
        }

        @Override
        public short getNodeType() {
            return 30;
        }

        public Iterator<InternalFactHandle> iterator() {
            return this.store.iterator();
        }

        @Override
        public SegmentMemory getSegmentMemory() {
            return null;
        }

        @Override
        public void setSegmentMemory(SegmentMemory segmentMemory) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Memory getPrevious() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPrevious(Memory previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void nullPrevNext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNext(Memory next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Memory getNext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
        }

        public String toString() {
            return "ObjectTypeMemory for " + this.classType;
        }
    }

    public static class ExpireJobContext
    implements JobContext,
    Externalizable {
        public final StatefulKnowledgeSessionImpl.WorkingMemoryReteExpireAction expireAction;
        public final InternalWorkingMemory workingMemory;
        public JobHandle handle;

        public ExpireJobContext(StatefulKnowledgeSessionImpl.WorkingMemoryReteExpireAction expireAction, InternalWorkingMemory workingMemory) {
            this.expireAction = expireAction;
            this.workingMemory = workingMemory;
        }

        @Override
        public JobHandle getJobHandle() {
            return this.handle;
        }

        @Override
        public void setJobHandle(JobHandle jobHandle) {
            this.handle = jobHandle;
        }

        public StatefulKnowledgeSessionImpl.WorkingMemoryReteExpireAction getExpireAction() {
            return this.expireAction;
        }

        @Override
        public InternalWorkingMemory getWorkingMemory() {
            return this.workingMemory;
        }

        public JobHandle getHandle() {
            return this.handle;
        }

        public void setHandle(JobHandle handle) {
            this.handle = handle;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }
    }

    public static class ExpireJob
    implements Job {
        @Override
        public void execute(JobContext ctx) {
            ExpireJobContext context = (ExpireJobContext)ctx;
            context.workingMemory.queueWorkingMemoryAction(context.expireAction);
            context.getExpireAction().getFactHandle().removeJob(context.getJobHandle());
        }
    }

    public static class Id {
        private final int otnId;
        private final int id;

        public Id(int otnId, int id) {
            this.otnId = otnId;
            this.id = id;
        }

        public String toString() {
            return "ObjectTypeNode.Id[" + this.otnId + "#" + this.id + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Id)) {
                return false;
            }
            Id otherId = (Id)o;
            return this.id == otherId.id && this.otnId == otherId.otnId;
        }

        public int hashCode() {
            return 31 * this.otnId + 37 * this.id;
        }

        public boolean before(Id otherId) {
            return otherId != null && (this.otnId < otherId.otnId || this.otnId == otherId.otnId && this.id < otherId.id);
        }

        public int getId() {
            return this.id;
        }
    }

    private static class IdGenerator {
        private final int otnId;
        private int otnIdCounter;

        private IdGenerator(int otnId) {
            this.otnId = otnId;
        }

        private Id nextId() {
            return new Id(this.otnId, this.otnIdCounter++);
        }

        private void reset() {
            this.otnIdCounter = 0;
        }
    }
}

