/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.drools.core.InitialFact;
import org.drools.core.QueryResultsImpl;
import org.drools.core.SessionConfiguration;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.base.CalendarsImpl;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.DroolsQuery;
import org.drools.core.base.MapGlobalResolver;
import org.drools.core.base.NonCloningQueryViewListener;
import org.drools.core.common.ActivationsManager;
import org.drools.core.common.ConcurrentNodeMemories;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.NodeMemories;
import org.drools.core.common.PhreakPropagationContext;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.event.RuleEventListenerSupport;
import org.drools.core.event.RuleRuntimeEventSupport;
import org.drools.core.impl.ActivationsManagerImpl;
import org.drools.core.impl.EntryPointsManager;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.reteoo.InitialFactImpl;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.FactHandleFactory;
import org.drools.core.spi.GlobalResolver;
import org.drools.core.spi.PropagationContext;
import org.drools.core.time.TimerService;
import org.drools.core.time.TimerServiceFactory;
import org.kie.api.runtime.Calendars;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.time.SessionClock;

public class RuleUnitExecutorImpl
implements ReteEvaluator {
    private final RuleRuntimeEventSupport ruleRuntimeEventSupport = new RuleRuntimeEventSupport();
    private final AtomicLong propagationIdCounter = new AtomicLong(1L);
    private final InternalKnowledgeBase kBase;
    private final SessionConfiguration sessionConfiguration;
    private final FactHandleFactory handleFactory;
    private final NodeMemories nodeMemories;
    private final ActivationsManager activationsManager;
    private final EntryPointsManager entryPointsManager;
    private final RuleEventListenerSupport ruleEventListenerSupport = new RuleEventListenerSupport();
    private final GlobalResolver globalResolver = new MapGlobalResolver();
    private final TimerService timerService;
    private Calendars calendars;

    public RuleUnitExecutorImpl(InternalKnowledgeBase knowledgeBase) {
        this(knowledgeBase, knowledgeBase.getSessionConfiguration());
    }

    public RuleUnitExecutorImpl(InternalKnowledgeBase knowledgeBase, SessionConfiguration sessionConfiguration) {
        this.kBase = knowledgeBase;
        this.sessionConfiguration = sessionConfiguration;
        this.handleFactory = knowledgeBase.newFactHandleFactory();
        this.nodeMemories = new ConcurrentNodeMemories(this.kBase);
        this.activationsManager = new ActivationsManagerImpl(this);
        this.entryPointsManager = new EntryPointsManager(this);
        this.timerService = TimerServiceFactory.getTimerService(sessionConfiguration);
        this.initInitialFact(this.kBase);
    }

    private void initInitialFact(InternalKnowledgeBase kBase) {
        InternalWorkingMemoryEntryPoint defaultEntryPoint = this.entryPointsManager.getDefaultEntryPoint();
        InitialFact initialFact = InitialFactImpl.getInstance();
        DefaultFactHandle handle = this.getFactHandleFactory().createDefaultFactHandle(0L, initialFact, 0L, defaultEntryPoint);
        ObjectTypeNode otn = defaultEntryPoint.getEntryPointNode().getObjectTypeNodes().get(ClassObjectType.InitialFact_ObjectType);
        if (otn != null) {
            PropagationContextFactory ctxFact = kBase.getConfiguration().getComponentFactory().getPropagationContextFactory();
            PropagationContext pctx = ctxFact.createPropagationContext(0L, PropagationContext.Type.INSERTION, null, null, handle, defaultEntryPoint.getEntryPoint(), null);
            otn.assertInitialFact(handle, pctx, this);
        }
    }

    @Override
    public ActivationsManager getActivationsManager() {
        return this.activationsManager;
    }

    @Override
    public InternalKnowledgeBase getKnowledgeBase() {
        return this.kBase;
    }

    @Override
    public Collection<? extends EntryPoint> getEntryPoints() {
        return this.entryPointsManager.getEntryPoints();
    }

    @Override
    public WorkingMemoryEntryPoint getEntryPoint(String name) {
        return this.entryPointsManager.getEntryPoint(name);
    }

    @Override
    public <T extends Memory> T getNodeMemory(MemoryFactory<T> node) {
        return this.nodeMemories.getNodeMemory(node, this);
    }

    @Override
    public GlobalResolver getGlobalResolver() {
        return this.globalResolver;
    }

    @Override
    public FactHandleFactory getFactHandleFactory() {
        return this.handleFactory;
    }

    @Override
    public InternalFactHandle getFactHandle(Object object) {
        return (InternalFactHandle)this.entryPointsManager.getDefaultEntryPoint().getFactHandle(object);
    }

    @Override
    public TimerService getTimerService() {
        return this.timerService;
    }

    @Override
    public void addPropagation(PropagationEntry propagationEntry, boolean register) {
        try {
            if (register) {
                this.startOperation();
            }
            this.activationsManager.addPropagation(propagationEntry);
        }
        finally {
            if (register) {
                this.endOperation();
            }
        }
    }

    @Override
    public long getNextPropagationIdCounter() {
        return this.propagationIdCounter.incrementAndGet();
    }

    @Override
    public SessionConfiguration getSessionConfiguration() {
        return this.sessionConfiguration;
    }

    @Override
    public RuleEventListenerSupport getRuleEventSupport() {
        return this.ruleEventListenerSupport;
    }

    @Override
    public RuleRuntimeEventSupport getRuleRuntimeEventSupport() {
        return this.ruleRuntimeEventSupport;
    }

    @Override
    public Calendars getCalendars() {
        if (this.calendars == null) {
            this.calendars = new CalendarsImpl();
        }
        return this.calendars;
    }

    @Override
    public SessionClock getSessionClock() {
        return (SessionClock)this.timerService;
    }

    @Override
    public int fireAllRules() {
        return this.fireAllRules(null, -1);
    }

    @Override
    public int fireAllRules(int fireLimit) {
        return this.fireAllRules(null, fireLimit);
    }

    @Override
    public int fireAllRules(AgendaFilter agendaFilter) {
        return this.fireAllRules(agendaFilter, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int fireAllRules(AgendaFilter agendaFilter, int fireLimit) {
        try {
            this.startOperation();
            int n = this.activationsManager.fireAllRules(agendaFilter, fireLimit);
            return n;
        }
        finally {
            this.endOperation();
        }
    }

    @Override
    public FactHandle insert(Object object) {
        return this.getDefaultEntryPoint().insert(object);
    }

    @Override
    public void dispose() {
        for (WorkingMemoryEntryPoint ep : this.entryPointsManager.getEntryPoints()) {
            ep.dispose();
        }
        this.ruleRuntimeEventSupport.clear();
        this.ruleEventListenerSupport.clear();
        this.timerService.shutdown();
    }

    @Override
    public QueryResults getQueryResults(String queryName, Object ... arguments) {
        this.activationsManager.flushPropagations();
        DroolsQuery queryObject = new DroolsQuery(queryName, arguments, new NonCloningQueryViewListener(), false);
        InternalFactHandle handle = this.handleFactory.newFactHandle(queryObject, null, this, this.getDefaultEntryPoint());
        PhreakPropagationContext pCtx = new PhreakPropagationContext(this.getNextPropagationIdCounter(), PropagationContext.Type.INSERTION, null, null, handle, this.getDefaultEntryPointId());
        PropagationEntry.ExecuteQuery executeQuery = new PropagationEntry.ExecuteQuery(queryName, queryObject, handle, pCtx, false);
        this.addPropagation(executeQuery);
        TerminalNode[] terminalNodes = (TerminalNode[])executeQuery.getResult();
        ArrayList<Map<String, Declaration>> decls = new ArrayList<Map<String, Declaration>>();
        if (terminalNodes != null) {
            for (TerminalNode node : terminalNodes) {
                decls.add(node.getSubRule().getOuterDeclarations());
            }
        }
        this.handleFactory.destroyFactHandle(handle);
        return new QueryResultsImpl(queryObject.getQueryResultCollector().getResults(), decls.toArray(new Map[decls.size()]), this, queryObject.getQuery() != null ? queryObject.getQuery().getParameters() : new Declaration[]{});
    }
}

