/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.lang.reflect.Field;
import java.util.Collections;
import org.drools.core.impl.RuleBase;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.core.reteoo.CompositeLeftTupleSinkAdapter;
import org.drools.core.reteoo.EmptyLeftTupleSinkAdapter;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkPropagator;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.MockLeftTupleSink;
import org.drools.core.reteoo.MockTupleSource;
import org.drools.core.reteoo.SingleLeftTupleSinkAdapter;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.test.model.DroolsTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBaseConfiguration;

public class TupleSourceTest
extends DroolsTestCase {
    @Test
    public void testObjectTupleConstructor() {
        KieBaseConfiguration kconf = RuleBaseFactory.newKnowledgeBaseConfiguration();
        RuleBase kBase = RuleBaseFactory.newRuleBase((KieBaseConfiguration)kconf);
        BuildContext buildContext = new BuildContext(kBase, Collections.emptyList());
        MockTupleSource source = new MockTupleSource(15, buildContext);
        Assert.assertEquals((long)15L, (long)source.getId());
    }

    @Test
    public void testAddTupleSink() throws Exception {
        KieBaseConfiguration kconf = RuleBaseFactory.newKnowledgeBaseConfiguration();
        RuleBase kBase = RuleBaseFactory.newRuleBase((KieBaseConfiguration)kconf);
        BuildContext buildContext = new BuildContext(kBase, Collections.emptyList());
        MockTupleSource source = new MockTupleSource(15, buildContext);
        Field field = LeftTupleSource.class.getDeclaredField("sink");
        field.setAccessible(true);
        LeftTupleSinkPropagator sink = (LeftTupleSinkPropagator)field.get((Object)source);
        Assert.assertSame((Object)EmptyLeftTupleSinkAdapter.getInstance(), (Object)sink);
        MockLeftTupleSink sink1 = new MockLeftTupleSink(buildContext);
        source.addTupleSink((LeftTupleSink)sink1);
        sink = (LeftTupleSinkPropagator)field.get((Object)source);
        Assert.assertSame(SingleLeftTupleSinkAdapter.class, sink.getClass());
        Assert.assertEquals((long)1L, (long)sink.getSinks().length);
        MockLeftTupleSink sink2 = new MockLeftTupleSink(buildContext);
        source.addTupleSink((LeftTupleSink)sink2);
        sink = (LeftTupleSinkPropagator)field.get((Object)source);
        Assert.assertSame(CompositeLeftTupleSinkAdapter.class, sink.getClass());
        Assert.assertEquals((long)2L, (long)sink.getSinks().length);
        MockLeftTupleSink sink3 = new MockLeftTupleSink(buildContext);
        source.addTupleSink((LeftTupleSink)sink3);
        Assert.assertSame(CompositeLeftTupleSinkAdapter.class, sink.getClass());
        Assert.assertEquals((long)3L, (long)sink.getSinks().length);
        source.removeTupleSink((LeftTupleSink)sink2);
        Assert.assertSame(CompositeLeftTupleSinkAdapter.class, sink.getClass());
        Assert.assertEquals((long)2L, (long)sink.getSinks().length);
        source.removeTupleSink((LeftTupleSink)sink1);
        sink = (LeftTupleSinkPropagator)field.get((Object)source);
        Assert.assertSame(SingleLeftTupleSinkAdapter.class, sink.getClass());
        Assert.assertEquals((long)1L, (long)sink.getSinks().length);
        source.removeTupleSink((LeftTupleSink)sink3);
        sink = (LeftTupleSinkPropagator)field.get((Object)source);
        Assert.assertSame((Object)EmptyLeftTupleSinkAdapter.getInstance(), (Object)sink);
        Assert.assertEquals((long)0L, (long)sink.getSinks().length);
    }
}

