/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.runtime.rule;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import org.drools.core.command.IdentifiableResult;
import org.drools.core.runtime.impl.ExecutionResultImpl;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.internal.command.RegistryContext;

@XmlAccessorType(value=XmlAccessType.NONE)
public class GetObjectsInEntryPointCommand
implements ExecutableCommand<Collection>,
IdentifiableResult {
    private ObjectFilter filter = null;
    @XmlAttribute(name="out-identifier")
    private String outIdentifier;
    @XmlAttribute(name="entry-point")
    private String entryPoint;

    @Override
    public String getOutIdentifier() {
        return this.outIdentifier;
    }

    @Override
    public void setOutIdentifier(String outIdentifier) {
        this.outIdentifier = outIdentifier;
    }

    public GetObjectsInEntryPointCommand() {
    }

    public GetObjectsInEntryPointCommand(ObjectFilter filter, String entryPoint) {
        this.filter = filter;
        this.entryPoint = entryPoint;
    }

    public GetObjectsInEntryPointCommand(ObjectFilter filter, String entryPoint, String outIdentifier) {
        this.filter = filter;
        this.entryPoint = entryPoint;
        this.outIdentifier = outIdentifier;
    }

    public Collection execute(Context context) {
        KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        EntryPoint ep = ksession.getEntryPoint(this.entryPoint);
        Collection col = null;
        col = this.filter != null ? ep.getObjects(this.filter) : ep.getObjects();
        if (this.outIdentifier != null) {
            ArrayList objects = new ArrayList(col);
            ((ExecutionResultImpl)((RegistryContext)context).lookup(ExecutionResultImpl.class)).setResult(this.outIdentifier, objects);
        }
        return col;
    }

    public String toString() {
        if (this.filter != null) {
            return "session.getEntryPoint( " + this.entryPoint + " ).iterateObjects( " + this.filter + " );";
        }
        return "session.getEntryPoint( " + this.entryPoint + " ).iterateObjects();";
    }
}

