/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.impl;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.impl.RuleBase;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.RuntimeComponentFactory;
import org.drools.core.rule.EntryPointId;

public class EntryPointsManager {
    private final ReteEvaluator reteEvaluator;
    private final RuleBase ruleBase;
    InternalWorkingMemoryEntryPoint defaultEntryPoint;
    private final Map<String, WorkingMemoryEntryPoint> entryPoints = new ConcurrentHashMap<String, WorkingMemoryEntryPoint>();

    public EntryPointsManager(ReteEvaluator reteEvaluator) {
        this.reteEvaluator = reteEvaluator;
        this.ruleBase = reteEvaluator.getKnowledgeBase();
        this.initDefaultEntryPoint();
        this.updateEntryPointsCache();
    }

    public InternalWorkingMemoryEntryPoint getDefaultEntryPoint() {
        return this.defaultEntryPoint;
    }

    public WorkingMemoryEntryPoint getEntryPoint(String name) {
        return this.entryPoints.get(name);
    }

    public Collection<WorkingMemoryEntryPoint> getEntryPoints() {
        return this.entryPoints.values();
    }

    public NamedEntryPoint createNamedEntryPoint(EntryPointNode addedNode, EntryPointId id) {
        return RuntimeComponentFactory.get().getNamedEntryPointFactory().createNamedEntryPoint(addedNode, id, this.reteEvaluator);
    }

    public void updateEntryPointsCache() {
        if (this.ruleBase.getAddedEntryNodeCache() != null) {
            for (EntryPointNode addedNode : this.ruleBase.getAddedEntryNodeCache()) {
                EntryPointId id = addedNode.getEntryPoint();
                if (EntryPointId.DEFAULT.equals(id)) continue;
                NamedEntryPoint wmEntryPoint = this.createNamedEntryPoint(addedNode, id);
                this.entryPoints.put(id.getEntryPointId(), wmEntryPoint);
            }
        }
        if (this.ruleBase.getRemovedEntryNodeCache() != null) {
            for (EntryPointNode removedNode : this.ruleBase.getRemovedEntryNodeCache()) {
                this.entryPoints.remove(removedNode.getEntryPoint().getEntryPointId());
            }
        }
    }

    public void reset() {
        this.defaultEntryPoint.reset();
        this.updateEntryPointsCache();
    }

    private void initDefaultEntryPoint() {
        this.defaultEntryPoint = this.createDefaultEntryPoint();
        this.entryPoints.clear();
        this.entryPoints.put("DEFAULT", this.defaultEntryPoint);
    }

    private InternalWorkingMemoryEntryPoint createDefaultEntryPoint() {
        EntryPointNode epn = this.ruleBase.getRete().getEntryPointNode(EntryPointId.DEFAULT);
        return this.createNamedEntryPoint(epn, EntryPointId.DEFAULT);
    }
}

