/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.impl;

import java.io.IOException;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.PhreakPropagationContextFactory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.spi.PropagationContext;

public class WorkingMemoryReteExpireAction
extends PropagationEntry.AbstractPropagationEntry
implements WorkingMemoryAction {
    protected EventFactHandle factHandle;
    protected ObjectTypeNode node;

    protected WorkingMemoryReteExpireAction() {
    }

    public WorkingMemoryReteExpireAction(EventFactHandle factHandle) {
        this.factHandle = factHandle;
    }

    public WorkingMemoryReteExpireAction(EventFactHandle factHandle, ObjectTypeNode node) {
        this(factHandle);
        this.node = node;
        factHandle.increaseOtnCount();
    }

    public EventFactHandle getFactHandle() {
        return this.factHandle;
    }

    public void setFactHandle(EventFactHandle factHandle) {
        this.factHandle = factHandle;
    }

    public ObjectTypeNode getNode() {
        return this.node;
    }

    public void setNode(ObjectTypeNode node) {
        this.node = node;
    }

    public WorkingMemoryReteExpireAction(MarshallerReaderContext context) throws IOException {
        this.factHandle = (EventFactHandle)context.getHandles().get(context.readLong());
        int nodeId = context.readInt();
        this.node = (ObjectTypeNode)context.getSinks().get(nodeId);
    }

    @Override
    public void execute(ReteEvaluator reteEvaluator) {
        if (!this.factHandle.isValid()) {
            return;
        }
        PropagationContext context = PhreakPropagationContextFactory.createPropagationContextForFact(reteEvaluator, this.factHandle, PropagationContext.Type.EXPIRATION);
        reteEvaluator.getActivationsManager().registerExpiration(context);
        this.factHandle.forEachLeftTuple(ObjectTypeNode::expireLeftTuple);
        this.factHandle.forEachRightTuple(rt -> {
            rt.setExpired(reteEvaluator, context);
            ObjectTypeNode.expireRightTuple(rt);
        });
        WorkingMemoryReteExpireAction.expireFactHandle(reteEvaluator, this.factHandle);
    }

    private static void expireFactHandle(ReteEvaluator reteEvaluator, EventFactHandle factHandle) {
        factHandle.decreaseOtnCount();
        if (factHandle.getOtnCount() == 0) {
            factHandle.setExpired(true);
            if (factHandle.getActivationsCount() == 0L) {
                String epId = factHandle.getEntryPointName();
                ((InternalWorkingMemoryEntryPoint)reteEvaluator.getEntryPoint(epId)).removeFromObjectStore(factHandle);
            } else {
                factHandle.setPendingRemoveFromStore(true);
            }
        }
    }

    @Override
    public boolean isPartitionSplittable() {
        return true;
    }

    @Override
    public PropagationEntry getSplitForPartition(int partitionNr) {
        return new PartitionAwareWorkingMemoryReteExpireAction(this.factHandle, this.node, partitionNr);
    }

    public String toString() {
        return "Expiration of " + this.factHandle.getObject();
    }

    public static class PartitionAwareWorkingMemoryReteExpireAction
    extends PropagationEntry.AbstractPartitionedPropagationEntry {
        private final EventFactHandle factHandle;
        private final ObjectTypeNode node;

        public PartitionAwareWorkingMemoryReteExpireAction(EventFactHandle factHandle, ObjectTypeNode node, int partition) {
            super(partition);
            this.factHandle = factHandle;
            this.node = node;
        }

        @Override
        public void execute(ReteEvaluator reteEvaluator) {
            if (!this.factHandle.isValid()) {
                return;
            }
            PropagationContext context = PhreakPropagationContextFactory.createPropagationContextForFact(reteEvaluator, this.factHandle, PropagationContext.Type.EXPIRATION);
            reteEvaluator.getActivationsManager().getPartitionedAgenda(this.partition).registerExpiration(context);
            DefaultFactHandle.CompositeLinkedTuples linkedTuples = (DefaultFactHandle.CompositeLinkedTuples)this.factHandle.getLinkedTuples();
            linkedTuples.forEachLeftTuple(this.partition, ObjectTypeNode::expireLeftTuple);
            linkedTuples.forEachRightTuple(this.partition, rt -> {
                rt.setExpired(reteEvaluator, context);
                ObjectTypeNode.expireRightTuple(rt);
            });
            if (this.isMainPartition()) {
                WorkingMemoryReteExpireAction.expireFactHandle(reteEvaluator, this.factHandle);
            }
        }

        public String toString() {
            return "Expiration of " + this.factHandle.getObject() + " for partition " + this.partition;
        }
    }
}

