/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.marshalling.impl;

import java.util.HashMap;
import java.util.Map;
import org.drools.core.common.BaseNode;
import org.drools.core.impl.RuleBase;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.QueryTerminalNode;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.WindowNode;

public class RuleBaseNodes {
    public static Map<Integer, BaseNode> getNodeMap(RuleBase kBase) {
        HashMap<Integer, BaseNode> nodes = new HashMap<Integer, BaseNode>();
        RuleBaseNodes.buildNodeMap(kBase, nodes);
        return nodes;
    }

    private static void buildNodeMap(RuleBase kBase, Map<Integer, BaseNode> nodes) {
        for (ObjectTypeNode sink : kBase.getRete().getObjectTypeNodes()) {
            nodes.put(sink.getId(), sink);
            RuleBaseNodes.addObjectSink(kBase, sink, nodes);
        }
    }

    private static void addObjectSink(RuleBase kBase, ObjectSink sink, Map<Integer, BaseNode> nodes) {
        if (sink instanceof LeftTupleSource) {
            LeftTupleSource node = (LeftTupleSource)((Object)sink);
            for (LeftTupleSink leftTupleSink : node.getSinkPropagator().getSinks()) {
                RuleBaseNodes.addLeftTupleSink(kBase, leftTupleSink, nodes);
            }
        } else if (sink instanceof WindowNode) {
            WindowNode node = (WindowNode)sink;
            nodes.put(sink.getId(), (BaseNode)((Object)sink));
            for (ObjectSink objectSink : node.getObjectSinkPropagator().getSinks()) {
                RuleBaseNodes.addObjectSink(kBase, objectSink, nodes);
            }
        } else {
            ObjectSource node = (ObjectSource)((Object)sink);
            for (ObjectSink objectSink : node.getObjectSinkPropagator().getSinks()) {
                RuleBaseNodes.addObjectSink(kBase, objectSink, nodes);
            }
        }
    }

    private static void addLeftTupleSink(RuleBase kBase, LeftTupleSink sink, Map<Integer, BaseNode> nodes) {
        if (sink instanceof LeftTupleSource) {
            nodes.put(sink.getId(), (LeftTupleSource)((Object)sink));
            for (LeftTupleSink leftTupleSink : ((LeftTupleSource)((Object)sink)).getSinkPropagator().getSinks()) {
                RuleBaseNodes.addLeftTupleSink(kBase, leftTupleSink, nodes);
            }
        } else if (sink instanceof ObjectSource) {
            nodes.put(sink.getId(), (ObjectSource)((Object)sink));
            for (ObjectSink objectSink : ((ObjectSource)((Object)sink)).getObjectSinkPropagator().getSinks()) {
                RuleBaseNodes.addObjectSink(kBase, objectSink, nodes);
            }
        } else if (sink instanceof RuleTerminalNode) {
            nodes.put(sink.getId(), (RuleTerminalNode)sink);
        } else if (sink instanceof QueryTerminalNode) {
            nodes.put(sink.getId(), (QueryTerminalNode)sink);
        }
    }
}

