/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.drools.core.common.MissingDependencyException;
import org.drools.core.util.Drools;
import org.kie.api.internal.utils.ServiceRegistry;

public interface XMLSupport {
    public static final String NO_XML_SUPPORT = "You're trying to perform a xml related operation without the necessary xml support for drools. Please add the module org.drools:drools-xml-support to your classpath.";

    public static <T> T throwExceptionForMissingXmlSupport() {
        if (Drools.isNativeImage()) {
            return null;
        }
        throw new MissingDependencyException(NO_XML_SUPPORT);
    }

    public static XMLSupport get() {
        return Holder.xmlSupport != null ? Holder.xmlSupport : (XMLSupport)XMLSupport.throwExceptionForMissingXmlSupport();
    }

    public static boolean present() {
        return Holder.xmlSupport != null;
    }

    default public String toXml(Object obj) {
        return this.toXml(Options.DEFAULT_OPTIONS, obj);
    }

    default public <T> T fromXml(String s) {
        return this.fromXml(Options.DEFAULT_OPTIONS, s);
    }

    public static Options options() {
        return new Options();
    }

    public String toXml(Options var1, Object var2);

    public <T> T fromXml(Options var1, String var2);

    public XmlMarshaller kieModuleMarshaller();

    public static class Options {
        static final Options DEFAULT_OPTIONS = new Options();
        private boolean dom = false;
        private boolean trusted = false;
        private ClassLoader classLoader;

        public Options useDom(boolean dom) {
            this.dom = dom;
            return this;
        }

        public boolean isDom() {
            return this.dom;
        }

        public Options trusted(boolean trusted) {
            this.trusted = trusted;
            return this;
        }

        public boolean isTrusted() {
            return this.trusted;
        }

        public Options withClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }
    }

    public static interface XmlMarshaller<T> {
        public String toXML(T var1);

        public T fromXML(String var1);

        public T fromXML(File var1);

        public T fromXML(URL var1);

        public T fromXML(InputStream var1);
    }

    public static class Holder {
        private static final XMLSupport xmlSupport = (XMLSupport)ServiceRegistry.getService(XMLSupport.class);
    }
}

