/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.runtime.process;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.drools.core.xml.jaxb.util.JaxbMapAdapter;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.command.ProcessInstanceIdCommand;
import org.kie.internal.command.RegistryContext;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class SetProcessInstanceVariablesCommand
implements ExecutableCommand<Void>,
ProcessInstanceIdCommand {
    private static final long serialVersionUID = 7802415761845739379L;
    @XmlAttribute(required=true)
    private String processInstanceId;
    @XmlJavaTypeAdapter(value=JaxbMapAdapter.class)
    @XmlElement(name="variables")
    private Map<String, Object> variables = new HashMap<String, Object>();

    public SetProcessInstanceVariablesCommand() {
    }

    public SetProcessInstanceVariablesCommand(String processInstanceId, Map<String, Object> variables) {
        this.processInstanceId = processInstanceId;
        this.variables = variables;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public Void execute(Context context) {
        KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        ProcessInstance processInstance = ksession.getProcessInstance(this.processInstanceId);
        if (processInstance != null && this.variables != null) {
            for (Map.Entry<String, Object> entry : this.variables.entrySet()) {
                ((WorkflowProcessInstance)processInstance).setVariable(entry.getKey(), entry.getValue());
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("WorkflowProcessInstance processInstance = (WorkflowProcessInstance) session.getProcessInstance(");
        result.append(this.processInstanceId);
        result.append(");");
        if (this.variables != null) {
            for (Map.Entry<String, Object> entry : this.variables.entrySet()) {
                result.append("\nprocessInstance.setVariable(\"");
                result.append(entry.getKey());
                result.append("\", ");
                result.append(entry.getValue() == null ? "null" : entry.getValue().toString());
                result.append(");");
            }
        }
        return result.toString();
    }
}

