/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.xml.changeset;

import java.util.Collection;
import java.util.HashSet;
import org.drools.core.io.impl.BaseResource;
import org.drools.core.io.impl.ClassPathResource;
import org.drools.core.io.impl.KnowledgeResource;
import org.drools.core.io.impl.UrlResource;
import org.drools.core.xml.BaseAbstractHandler;
import org.drools.core.xml.ExtensibleXmlParser;
import org.drools.core.xml.Handler;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ResourceHandler
extends BaseAbstractHandler
implements Handler {
    public ResourceHandler() {
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet(1);
            this.validParents.add(Collection.class);
            this.validPeers = new HashSet(2);
            this.validPeers.add(null);
            this.validPeers.add(Resource.class);
            this.allowNesting = true;
        }
    }

    @Override
    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        Collection collection = (Collection)parser.getParent();
        String src = attrs.getValue("source");
        String type = attrs.getValue("type");
        String basicAuthentication = attrs.getValue("basicAuthentication");
        String username = attrs.getValue("username");
        String password = attrs.getValue("password");
        String name = attrs.getValue("name");
        String description = attrs.getValue("description");
        String categories = attrs.getValue("categories");
        this.emptyAttributeCheck(localName, "source", src, parser);
        this.emptyAttributeCheck(localName, "type", type, parser);
        BaseResource resource = null;
        if (src.trim().startsWith("classpath:")) {
            resource = new ClassPathResource(src.substring(src.indexOf(58) + 1), parser.getClassLoader());
        } else {
            resource = new UrlResource(src);
            ((UrlResource)resource).setBasicAuthentication(basicAuthentication);
            ((UrlResource)resource).setUsername(username);
            ((UrlResource)resource).setPassword(password);
        }
        resource.setResourceType(ResourceType.determineResourceType((String)type));
        resource.setSourcePath(name);
        resource.setDescription(description);
        resource.setCategories(categories);
        return resource;
    }

    @Override
    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        Collection collection = (Collection)parser.getParent();
        Resource resource = (Resource)parser.getCurrent();
        collection.add(resource);
        return resource;
    }

    @Override
    public Class<?> generateNodeFor() {
        return KnowledgeResource.class;
    }
}

