/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.io.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.drools.util.io.ByteArrayResource;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ByteArrayResourceToStringTest {
    @Parameterized.Parameter(value=0)
    public List<Byte> bytes;
    @Parameterized.Parameter(value=1)
    public String encoding;
    @Parameterized.Parameter(value=2)
    public String expectedString;

    @Parameterized.Parameters(name="{index}: bytes={0}, encoding={1}")
    public static Collection<Object[]> data() {
        return new ArrayList<Object[]>(Arrays.asList({Arrays.asList((byte)10, (byte)20, (byte)30, (byte)40), null, "ByteArrayResource[bytes=[10, 20, 30, 40], encoding=null]"}, {Arrays.asList((byte)10, (byte)20, (byte)30, (byte)40, (byte)50, (byte)60, (byte)70, (byte)80, (byte)90, (byte)100), null, "ByteArrayResource[bytes=[10, 20, 30, 40, 50, 60, 70, 80, 90, 100], encoding=null]"}, {Arrays.asList((byte)10, (byte)20, (byte)30, (byte)40, (byte)50, (byte)60, (byte)70, (byte)80, (byte)90, (byte)100, (byte)110, (byte)120), null, "ByteArrayResource[bytes=[10, 20, 30, 40, 50, 60, 70, 80, 90, 100, ...], encoding=null]"}, {Arrays.asList((byte)10, (byte)20, (byte)30, (byte)40, (byte)50, (byte)60, (byte)70, (byte)80, (byte)90, (byte)100, (byte)110, (byte)120), "UTF-8", "ByteArrayResource[bytes=[10, 20, 30, 40, 50, 60, 70, 80, 90, 100, ...], encoding=UTF-8]"}));
    }

    @Test
    public void testToString() {
        byte[] byteArray = ArrayUtils.toPrimitive((Byte[])this.bytes.toArray(new Byte[0]));
        ByteArrayResource byteArrayResource = new ByteArrayResource(byteArray, this.encoding);
        Assert.assertEquals((Object)this.expectedString, (Object)byteArrayResource.toString());
    }
}

