/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.base.ObjectType;
import org.drools.core.facttemplates.FactTemplate;
import org.drools.core.facttemplates.FactTemplateObjectType;
import org.drools.core.impl.RuleBase;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.rule.EntryPointId;
import org.drools.core.rule.TypeDeclaration;

public class FactTemplateTypeConf
implements ObjectTypeConf,
Externalizable {
    private static final long serialVersionUID = 510L;
    private transient RuleBase ruleBase;
    private ObjectType objectType;
    private FactTemplate factTemplate;
    private ObjectTypeNode concreteObjectTypeNode;
    private ObjectTypeNode[] cache;
    private boolean tmsEnabled;
    EntryPointId entryPoint;

    public FactTemplateTypeConf() {
    }

    public FactTemplateTypeConf(EntryPointId entryPoint, FactTemplate factTemplate, RuleBase ruleBase) {
        this.ruleBase = ruleBase;
        this.factTemplate = factTemplate;
        this.entryPoint = entryPoint;
        this.objectType = new FactTemplateObjectType(factTemplate);
        this.concreteObjectTypeNode = ruleBase.getRete().getObjectTypeNodes(entryPoint).get(this.objectType);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ruleBase = (RuleBase)in.readObject();
        this.factTemplate = (FactTemplate)in.readObject();
        this.concreteObjectTypeNode = (ObjectTypeNode)in.readObject();
        this.cache = (ObjectTypeNode[])in.readObject();
        this.objectType = (ObjectType)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.ruleBase);
        out.writeObject(this.factTemplate);
        out.writeObject(this.concreteObjectTypeNode);
        out.writeObject(this.cache);
        out.writeObject(this.objectType);
    }

    @Override
    public ObjectTypeNode getConcreteObjectTypeNode() {
        if (this.concreteObjectTypeNode == null) {
            this.concreteObjectTypeNode = this.ruleBase.getRete().getObjectTypeNodes(this.entryPoint).get(this.objectType);
        }
        return this.concreteObjectTypeNode;
    }

    @Override
    public ObjectTypeNode[] getObjectTypeNodes() {
        if (this.cache == null) {
            ObjectTypeNode[] objectTypeNodeArray;
            if (this.concreteObjectTypeNode != null) {
                ObjectTypeNode[] objectTypeNodeArray2 = new ObjectTypeNode[1];
                objectTypeNodeArray = objectTypeNodeArray2;
                objectTypeNodeArray2[0] = this.concreteObjectTypeNode;
            } else {
                objectTypeNodeArray = new ObjectTypeNode[]{};
            }
            this.cache = objectTypeNodeArray;
        }
        return this.cache;
    }

    @Override
    public boolean isAssignableFrom(Object object) {
        return this.factTemplate.equals(object);
    }

    @Override
    public void resetCache() {
        this.cache = null;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public boolean isEvent() {
        return false;
    }

    public boolean isTrait() {
        return false;
    }

    @Override
    public TypeDeclaration getTypeDeclaration() {
        return null;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public boolean isTMSEnabled() {
        return this.tmsEnabled;
    }

    @Override
    public void enableTMS() {
        this.tmsEnabled = true;
    }

    @Override
    public EntryPointId getEntryPoint() {
        return this.entryPoint;
    }

    @Override
    public String getTypeName() {
        return this.factTemplate.getName();
    }
}

