/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.io.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import org.assertj.core.api.Assertions;
import org.drools.util.io.ByteArrayResource;
import org.junit.Test;

public class ByteArrayResourceSerializationTest {
    @Test
    public void bytesAttributesIsStillSerializedDeserializedCorrectly() throws IOException, ClassNotFoundException {
        ByteArrayResource desBar;
        byte[] serializedBar;
        byte[] content = "some content".getBytes(StandardCharsets.UTF_8);
        ByteArrayResource bar = new ByteArrayResource(content, StandardCharsets.UTF_8.toString());
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(bar);
            serializedBar = baos.toByteArray();
        }
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(serializedBar));){
            desBar = (ByteArrayResource)ois.readObject();
        }
        Assertions.assertThat((byte[])desBar.getBytes()).isEqualTo((Object)content);
    }
}

