/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.assertj.core.api.Assertions;
import org.drools.core.ObjectFilter;
import org.drools.core.common.ClassAwareObjectStore;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ClassAwareObjectStoreTest {
    private final ClassAwareObjectStore underTest;
    private static final AtomicInteger factCounter = new AtomicInteger(0);

    @Test
    public void iterateObjectsReturnsObjectsOfAllTypes() throws Exception {
        String aStringValue = "a string";
        BigDecimal bigDecimalValue = new BigDecimal("1");
        this.insertObjectWithFactHandle(aStringValue);
        this.insertObjectWithFactHandle(bigDecimalValue);
        Collection result = ClassAwareObjectStoreTest.collect(this.underTest.iterateObjects());
        Assertions.assertThat(result).hasSize(2);
    }

    @Test
    public void iterateByClassFiltersByClass() {
        SimpleClass object = new SimpleClass();
        this.insertObjectWithFactHandle("some string");
        this.insertObjectWithFactHandle(object);
        Collection results = ClassAwareObjectStoreTest.collect(this.underTest.iterateObjects(SimpleClass.class));
        Assertions.assertThat(results).hasSize(1);
        Assertions.assertThat(results).contains(new Object[]{object});
    }

    @Test
    public void queryBySuperTypeFindsSubType() throws Exception {
        this.insertObjectWithFactHandle(new SubClass());
        this.insertObjectWithFactHandle(new SuperClass());
        Collection result = ClassAwareObjectStoreTest.collect(this.underTest.iterateObjects(SuperClass.class));
        Assertions.assertThat(result).hasSize(2);
        Assertions.assertThat(result).hasAtLeastOneElementOfType(SubClass.class);
        Assertions.assertThat(result).hasAtLeastOneElementOfType(SuperClass.class);
    }

    @Test
    public void queryBySubtypeDoesNotReturnSuperType() throws Exception {
        this.insertObjectWithFactHandle(new SubClass());
        this.insertObjectWithFactHandle(new SuperClass());
        Collection result = ClassAwareObjectStoreTest.collect(this.underTest.iterateObjects(SubClass.class));
        Assertions.assertThat(result).hasSize(1);
        Assertions.assertThat(result).hasAtLeastOneElementOfType(SubClass.class);
    }

    @Test
    public void queryBySubTypeDoesNotPreventInsertionsBeingPropogatedToSuperTypeQueries() throws Exception {
        this.insertObjectWithFactHandle(new SuperClass());
        ClassAwareObjectStoreTest.collect(this.underTest.iterateObjects(SubClass.class));
        this.insertObjectWithFactHandle(new SubClass());
        Collection result = ClassAwareObjectStoreTest.collect(this.underTest.iterateObjects(SuperClass.class));
        Assertions.assertThat(result).hasSize(2);
        Assertions.assertThat(result).hasAtLeastOneElementOfType(SubClass.class);
        Assertions.assertThat(result).hasAtLeastOneElementOfType(SuperClass.class);
    }

    @Test
    public void queryBySuperTypeCanFindSubTypeWhenNoSuperTypeInstancesAreInStore() throws Exception {
        this.insertObjectWithFactHandle(new SubClass());
        Collection result = ClassAwareObjectStoreTest.collect(this.underTest.iterateObjects(SuperClass.class));
        Assertions.assertThat(result).hasSize(1);
        Assertions.assertThat(result).hasAtLeastOneElementOfType(SubClass.class);
    }

    @Test
    public void isOkayToReinsertSameTypeThenQuery() throws Exception {
        this.insertObjectWithFactHandle(new SubClass());
        this.insertObjectWithFactHandle(new SubClass());
        Collection result = ClassAwareObjectStoreTest.collect(this.underTest.iterateObjects(SuperClass.class));
        Assertions.assertThat(result).hasSize(2);
        Assertions.assertThat(new HashSet(result)).hasSize(2);
    }

    @Test
    public void onceSuperClassIsSetUpForReadingItCanBecomeSetUpForWritingWithoutGettingDuplicateQueryReturns() throws Exception {
        Assertions.assertThat((boolean)ClassAwareObjectStoreTest.collect(this.underTest.iterateObjects(SuperClass.class)).isEmpty()).isTrue();
        this.insertObjectWithFactHandle(new SubClass());
        this.insertObjectWithFactHandle(new SuperClass());
        Collection result = ClassAwareObjectStoreTest.collect(this.underTest.iterateObjects(SuperClass.class));
        Assertions.assertThat(result).hasSize(2);
        Assertions.assertThat(new HashSet(result)).hasSize(2);
    }

    @Test
    public void clearRemovesInsertedObjects() throws Exception {
        this.insertObjectWithFactHandle(new SimpleClass());
        Assertions.assertThat(ClassAwareObjectStoreTest.collect(this.underTest.iterateObjects())).hasSize(1);
        this.underTest.clear();
        Assertions.assertThat(ClassAwareObjectStoreTest.collect(this.underTest.iterateObjects())).hasSize(0);
    }

    @Test
    public void canIterateOverObjectsUsingCustomFilter() throws Exception {
        this.insertObjectWithFactHandle(new SuperClass());
        this.insertObjectWithFactHandle(new SubClass());
        Collection result = ClassAwareObjectStoreTest.collect(this.underTest.iterateObjects((org.kie.api.runtime.ObjectFilter)new ObjectFilter(){

            public boolean accept(Object o) {
                return SubClass.class.isInstance(o);
            }
        }));
        Assertions.assertThat(result).hasSize(1);
        Assertions.assertThat(result).hasAtLeastOneElementOfType(SubClass.class);
    }

    @Test
    public void iteratingOverFactHandlesHasSameNumberOfResultsAsIteratingOverObjects() throws Exception {
        this.insertObjectWithFactHandle(new SuperClass());
        this.insertObjectWithFactHandle(new SubClass());
        Assertions.assertThat(ClassAwareObjectStoreTest.collect(this.underTest.iterateFactHandles(SubClass.class))).hasSize(1);
        Assertions.assertThat(ClassAwareObjectStoreTest.collect(this.underTest.iterateFactHandles(SuperClass.class))).hasSize(2);
    }

    private void insertObjectWithFactHandle(Object objectToInsert) {
        this.underTest.addHandle(this.handleFor(objectToInsert), objectToInsert);
    }

    public ClassAwareObjectStore getUnderTest() {
        return this.underTest;
    }

    private static <T> Collection<T> collect(Iterator<T> objects) {
        ArrayList<T> result = new ArrayList<T>();
        while (objects.hasNext()) {
            result.add(objects.next());
        }
        return result;
    }

    public ClassAwareObjectStoreTest(boolean isEqualityBehaviour) {
        this.underTest = new ClassAwareObjectStore(isEqualityBehaviour, (Lock)new ReentrantLock());
    }

    @Parameterized.Parameters
    public static Collection<Object[]> ruleBaseConfigurations() {
        ArrayList<Object[]> configurations = new ArrayList<Object[]>(2);
        configurations.add(new Object[]{true});
        configurations.add(new Object[]{false});
        return configurations;
    }

    private InternalFactHandle handleFor(Object object) {
        return new DefaultFactHandle((long)factCounter.getAndIncrement(), object);
    }

    private static class SubClass
    extends SuperClass {
        private SubClass() {
        }
    }

    private static class SuperClass {
        private SuperClass() {
        }
    }

    private static class SimpleClass {
        private SimpleClass() {
        }
    }
}

