/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ObjectStore;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.FactHandle;

public class ObjectStoreWrapper
implements Collection {
    public ObjectStore store;
    public ObjectFilter filter;
    public int type;
    public static final int OBJECT = 0;
    public static final int FACT_HANDLE = 1;

    public ObjectStoreWrapper(ObjectStore store, ObjectFilter filter, int type) {
        this.store = store;
        this.filter = filter;
        this.type = type;
    }

    @Override
    public boolean contains(Object object) {
        if (object instanceof FactHandle) {
            return this.store.getObjectForHandle((InternalFactHandle)object) != null;
        }
        return this.store.getHandleForObject(object) != null;
    }

    public boolean containsAll(Collection c) {
        for (Object object : c) {
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        if (this.filter == null) {
            return this.store.isEmpty();
        }
        return this.size() == 0;
    }

    @Override
    public int size() {
        if (this.filter == null) {
            return this.store.size();
        }
        int i = 0;
        for (Object o : this) {
            ++i;
        }
        return i;
    }

    @Override
    public Iterator<?> iterator() {
        Iterator<Object> it = this.type == 0 ? (this.filter != null ? this.store.iterateObjects(this.filter) : this.store.iterateObjects()) : (this.filter != null ? this.store.iterateFactHandles(this.filter) : this.store.iterateFactHandles());
        return it;
    }

    @Override
    public Object[] toArray() {
        return this.asList().toArray();
    }

    public Object[] toArray(Object[] array) {
        return this.asList().toArray(array);
    }

    private List asList() {
        ArrayList list = new ArrayList();
        for (Object o : this) {
            list.add(o);
        }
        return list;
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException("This is an immmutable Collection");
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException("This is an immmutable Collection");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("This is an immmutable Collection");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("This is an immmutable Collection");
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException("This is an immmutable Collection");
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException("This is an immmutable Collection");
    }
}

