/*
 * Copyright 2010 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.core.rule.accessor;

import java.io.Serializable;
import java.util.Iterator;

import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.reteoo.Tuple;
import org.drools.core.rule.Declaration;

public interface DataProvider
    extends
    Serializable,
    Cloneable {

    Declaration[] getRequiredDeclarations();

    Object createContext();

    Iterator getResults(Tuple tuple,
                        ReteEvaluator reteEvaluator,
                        PropagationContext ctx,
                        Object providerContext);

    DataProvider clone();

    void replaceDeclaration(Declaration declaration,
                            Declaration resolved);

    boolean isReactive();
}
