/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.accumulators;

import org.assertj.core.api.Assertions;
import org.drools.core.base.accumulators.VarianceAccumulateFunction;
import org.junit.Test;

public class VarianceNaNTest {
    @Test
    public void shouldNotProduceNaNAfterBackout() {
        VarianceAccumulateFunction varianceAccumulateFunction = new VarianceAccumulateFunction();
        VarianceAccumulateFunction.VarianceData data = varianceAccumulateFunction.createContext();
        varianceAccumulateFunction.init(data);
        Assertions.assertThat((Double)varianceAccumulateFunction.getResult(data)).isCloseTo(Double.NaN, Assertions.within((Double)0.0));
        Double value = 1.5;
        varianceAccumulateFunction.accumulate(data, (Object)value);
        Assertions.assertThat((Double)varianceAccumulateFunction.getResult(data)).isCloseTo(0.0, Assertions.within((Double)0.001));
        varianceAccumulateFunction.reverse(data, (Object)value);
        Assertions.assertThat((Double)varianceAccumulateFunction.getResult(data)).isCloseTo(Double.NaN, Assertions.within((Double)0.0));
        varianceAccumulateFunction.accumulate(data, (Object)value);
        Assertions.assertThat((Double)varianceAccumulateFunction.getResult(data)).isCloseTo(0.0, Assertions.within((Double)0.001));
    }
}

