/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.InternalRuleFlowGroup;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.VisitedAgendaGroup;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.conflict.PhreakConflictResolver;
import org.drools.core.impl.RuleBase;
import org.drools.core.marshalling.MarshallerReaderContext;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.rule.consequence.Activation;
import org.drools.core.util.ArrayQueue;
import org.drools.core.util.BinaryHeapQueue;
import org.drools.core.util.Queue;

public class AgendaGroupQueueImpl
implements InternalAgendaGroup,
InternalRuleFlowGroup {
    private static final long serialVersionUID = 510L;
    private final String name;
    private Queue priorityQueue;
    private volatile boolean active;
    private PropagationContext autoFocusActivator;
    private long activatedForRecency;
    private long clearedForRecency;
    private ReteEvaluator reteEvaluator;
    private boolean autoDeactivate = true;
    private Map<Object, String> nodeInstances = new ConcurrentHashMap<Object, String>();
    private volatile boolean hasRuleFlowLister;
    private Activation lastRemoved;
    private final boolean sequential;

    public AgendaGroupQueueImpl(String name, RuleBase kBase) {
        this.name = name;
        this.sequential = kBase.getConfiguration().isSequential();
        this.clearedForRecency = -1L;
    }

    @Override
    public void visited() {
        if (this.sequential) {
            this.lastRemoved = VisitedAgendaGroup.INSTANCE;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setReteEvaluator(ReteEvaluator reteEvaluator) {
        this.reteEvaluator = reteEvaluator;
        this.priorityQueue = reteEvaluator != null && reteEvaluator.getSessionConfiguration().isDirectFiring() ? new ArrayQueue() : new BinaryHeapQueue(new PhreakConflictResolver());
    }

    @Override
    public void hasRuleFlowListener(boolean hasRuleFlowLister) {
        this.hasRuleFlowLister = hasRuleFlowLister;
    }

    @Override
    public boolean isRuleFlowListener() {
        return this.hasRuleFlowLister;
    }

    public void clear() {
        this.reteEvaluator.addPropagation(new ClearAction(this.name));
    }

    public void setFocus() {
        this.reteEvaluator.addPropagation(new SetFocusAction(this.name));
    }

    @Override
    public void reset() {
        this.priorityQueue.clear();
        this.lastRemoved = null;
    }

    @Override
    public Activation[] getAndClear() {
        return this.priorityQueue.getAndClear();
    }

    @Override
    public int size() {
        return this.priorityQueue.size();
    }

    @Override
    public void add(Activation activation) {
        if (this.lastRemoved != null && (this.lastRemoved == activation || this.lastRemoved == VisitedAgendaGroup.INSTANCE || PhreakConflictResolver.doCompare(this.lastRemoved, activation) < 0)) {
            return;
        }
        this.priorityQueue.enqueue(activation);
    }

    @Override
    public Activation remove() {
        Activation match = this.priorityQueue.dequeue();
        if (this.sequential) {
            this.lastRemoved = match;
        }
        return match;
    }

    @Override
    public Activation peek() {
        return this.priorityQueue.peek();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isAutoDeactivate() {
        return this.autoDeactivate;
    }

    @Override
    public void setAutoDeactivate(boolean autoDeactivate) {
        this.autoDeactivate = autoDeactivate;
    }

    @Override
    public void addNodeInstance(Object processInstanceId, String nodeInstanceId) {
        this.nodeInstances.put(processInstanceId, nodeInstanceId);
    }

    @Override
    public void removeNodeInstance(Object processInstanceId, String nodeInstanceId) {
        this.nodeInstances.put(processInstanceId, nodeInstanceId);
    }

    @Override
    public void setActive(boolean activate) {
        this.active = activate;
    }

    @Override
    public PropagationContext getAutoFocusActivator() {
        return this.autoFocusActivator;
    }

    @Override
    public void setAutoFocusActivator(PropagationContext autoFocusActivator) {
        this.autoFocusActivator = autoFocusActivator;
    }

    @Override
    public boolean isEmpty() {
        return this.priorityQueue.isEmpty();
    }

    @Override
    public Activation[] getActivations() {
        return (Activation[])this.priorityQueue.toArray(new AgendaItem[this.priorityQueue.size()]);
    }

    @Override
    public Map<Object, String> getNodeInstances() {
        return this.nodeInstances;
    }

    public String toString() {
        return "AgendaGroup '" + this.name + "'";
    }

    public boolean equals(Object object) {
        return object instanceof AgendaGroupQueueImpl && ((AgendaGroupQueueImpl)object).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public void remove(Activation activation) {
        this.priorityQueue.dequeue(activation);
    }

    @Override
    public long getActivatedForRecency() {
        return this.activatedForRecency;
    }

    @Override
    public void setActivatedForRecency(long recency) {
        this.activatedForRecency = recency;
    }

    @Override
    public long getClearedForRecency() {
        return this.clearedForRecency;
    }

    @Override
    public void setClearedForRecency(long recency) {
        this.clearedForRecency = recency;
    }

    @Override
    public boolean isSequential() {
        return this.sequential;
    }

    public static class DeactivateCallback
    extends PropagationEntry.AbstractPropagationEntry
    implements WorkingMemoryAction {
        private static final long serialVersionUID = 510L;
        protected final InternalRuleFlowGroup ruleFlowGroup;

        public DeactivateCallback(InternalRuleFlowGroup ruleFlowGroup) {
            this.ruleFlowGroup = ruleFlowGroup;
        }

        public DeactivateCallback(MarshallerReaderContext context) throws IOException {
            this.ruleFlowGroup = (InternalRuleFlowGroup)context.getWorkingMemory().getAgenda().getRuleFlowGroup(context.readUTF());
        }

        @Override
        public void execute(ReteEvaluator reteEvaluator) {
            if (this.ruleFlowGroup.isEmpty()) {
                this.ruleFlowGroup.setActive(false);
            }
        }
    }

    public class SetFocusAction
    extends PropagationEntry.AbstractPropagationEntry {
        private final String name;

        public SetFocusAction(String name) {
            this.name = name;
        }

        @Override
        public void execute(ReteEvaluator reteEvaluator) {
            ((InternalAgenda)reteEvaluator.getActivationsManager()).setFocus(this.name);
        }

        @Override
        public boolean defersExpiration() {
            return true;
        }
    }

    public class ClearAction
    extends PropagationEntry.AbstractPropagationEntry {
        private final String name;

        public ClearAction(String name) {
            this.name = name;
        }

        @Override
        public void execute(ReteEvaluator reteEvaluator) {
            ((InternalAgenda)reteEvaluator.getActivationsManager()).clearAndCancelAgendaGroup(this.name);
        }
    }
}

