/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.assertj.core.api.Assertions;
import org.drools.core.common.DroolsObjectInputStream;
import org.drools.core.common.DroolsObjectOutputStream;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.reteoo.CoreComponentFactory;
import org.drools.core.rule.GroupElement;
import org.drools.core.util.DroolsStreamUtils;
import org.junit.Test;

public class DroolsObjectIOTest {
    @Test
    public void testFileIO() throws Exception {
        FooBar fooBar1 = new FooBar();
        ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
        new ObjectOutputStream(byteArrayOut).writeObject(fooBar1);
        ByteArrayInputStream byteArrayIn = new ByteArrayInputStream(byteArrayOut.toByteArray());
        FooBar fooBar2 = (FooBar)new ObjectInputStream(byteArrayIn).readObject();
        File testFile = new File("target/test/DroolsObjectIOTest_testFileIO.dat");
        testFile.getParentFile().mkdirs();
        GroupElement testGroupElement = new GroupElement();
        DroolsStreamUtils.streamOut(new FileOutputStream(testFile), testGroupElement);
        FileInputStream fis = new FileInputStream(testFile);
        GroupElement streamedGroupElement = (GroupElement)DroolsStreamUtils.streamIn(new FileInputStream(testFile));
        Assertions.assertThat((Object)testGroupElement).isEqualTo((Object)streamedGroupElement);
    }

    @Test
    public void testObject() throws Exception {
        SerializableObject obj = new ExternalizableObject();
        byte[] buf = DroolsObjectIOTest.serialize(obj);
        Assertions.assertThat((Object)obj).isEqualTo(DroolsObjectIOTest.deserialize(buf));
        obj = new SerializableObject();
        buf = DroolsObjectIOTest.serialize(obj);
        Assertions.assertThat((Object)obj).isEqualTo(DroolsObjectIOTest.deserialize(buf));
    }

    private static Object deserialize(byte[] buf) throws Exception {
        return new DroolsObjectInputStream((InputStream)new ByteArrayInputStream(buf)).readObject();
    }

    private static byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DroolsObjectOutputStream out = new DroolsObjectOutputStream((OutputStream)bytes);
        out.writeObject(obj);
        out.flush();
        out.close();
        return bytes.toByteArray();
    }

    private static Object unmarshal(byte[] buf) throws Exception {
        return new ObjectInputStream(new ByteArrayInputStream(buf)).readObject();
    }

    private static byte[] marshal(Object obj) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bytes);
        out.writeObject(obj);
        out.flush();
        out.close();
        return bytes.toByteArray();
    }

    @Test
    public void testStreaming() throws Exception {
        InternalKnowledgePackage pkg = CoreComponentFactory.get().createKnowledgePackage("test");
        byte[] buf = DroolsObjectIOTest.marshal(pkg);
        Assertions.assertThat((Object)pkg).isEqualTo(DroolsObjectIOTest.unmarshal(buf));
        buf = DroolsObjectIOTest.serialize(pkg);
        Assertions.assertThat((Object)pkg).isEqualTo(DroolsObjectIOTest.deserialize(buf));
    }

    @Test
    public void testRuleStreamingWithCalendar() throws Exception {
        RuleImpl rule = new RuleImpl("test");
        rule.setCalendars(new String[]{"mycalendar"});
        byte[] buf = DroolsObjectIOTest.marshal(rule);
        RuleImpl retrievedRule = (RuleImpl)DroolsObjectIOTest.unmarshal(buf);
        Assertions.assertThat((Object)retrievedRule).isNotNull();
        Assertions.assertThat((Object[])retrievedRule.getCalendars()).isNotNull();
        Assertions.assertThat((Object[])retrievedRule.getCalendars()).hasSize(1);
        Assertions.assertThat((String)retrievedRule.getCalendars()[0]).isEqualTo("mycalendar");
    }

    public static class ExternalizableObject
    extends SerializableObject
    implements Externalizable {
        public ExternalizableObject() {
            super("ExternalizableObject");
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.value = in.readInt();
            this.name = (String)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.value);
            out.writeObject(this.name);
        }
    }

    public static class SerializableObject
    implements Serializable {
        protected int value = 123;
        protected String name;

        public SerializableObject() {
            this("SerializableObject");
        }

        public SerializableObject(String name) {
            this.name = name;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SerializableObject) {
                return this.value == ((SerializableObject)obj).value;
            }
            return false;
        }

        public String toString() {
            return this.name + '|' + this.value;
        }
    }

    private static class FooBar
    implements Serializable {
        private String value = "hello";
    }
}

