/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.core.common.ActivationGroupNode;
import org.drools.core.common.ActivationNode;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.Tuple;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.GroupElement;
import org.drools.core.rule.consequence.Consequence;
import org.kie.api.runtime.rule.FactHandle;

public class AgendaItemImpl
implements AgendaItem {
    private static final long serialVersionUID = 510L;
    private Tuple tuple;
    private int salience;
    private TerminalNode rtn;
    private PropagationContext context;
    private long activationNumber;
    private int index;
    private boolean queued;
    private transient InternalAgendaGroup agendaGroup;
    private ActivationGroupNode activationGroupNode;
    private ActivationNode activationNode;
    private InternalFactHandle factHandle;
    private transient boolean canceled;
    private boolean matched;
    private boolean active;
    private Runnable callback;

    public AgendaItemImpl() {
    }

    public AgendaItemImpl(long activationNumber, Tuple tuple, int salience, PropagationContext context, TerminalNode rtn, InternalAgendaGroup agendaGroup) {
        this.tuple = tuple;
        this.context = context;
        this.salience = salience;
        this.rtn = rtn;
        this.activationNumber = activationNumber;
        this.index = -1;
        this.matched = true;
        this.agendaGroup = agendaGroup;
    }

    @Override
    public PropagationContext getPropagationContext() {
        return this.context;
    }

    @Override
    public RuleImpl getRule() {
        return this.rtn.getRule();
    }

    public RuleBasePartitionId getPartition() {
        return this.rtn.getPartitionId();
    }

    @Override
    public Consequence getConsequence() {
        String consequenceName = ((RuleTerminalNode)this.rtn).getConsequenceName();
        return consequenceName.equals("default") ? this.rtn.getRule().getConsequence() : this.rtn.getRule().getNamedConsequence(consequenceName);
    }

    @Override
    public Tuple getTuple() {
        return this.tuple;
    }

    @Override
    public int getSalience() {
        return this.salience;
    }

    @Override
    public void setSalience(int salience) {
        this.salience = salience;
    }

    @Override
    public InternalFactHandle getActivationFactHandle() {
        return this.factHandle;
    }

    @Override
    public void setActivationFactHandle(InternalFactHandle factHandle) {
        this.factHandle = factHandle;
    }

    @Override
    public RuleAgendaItem getRuleAgendaItem() {
        return null;
    }

    @Override
    public long getActivationNumber() {
        return this.activationNumber;
    }

    @Override
    public boolean isQueued() {
        return this.queued;
    }

    @Override
    public void setQueued(boolean queued) {
        this.queued = queued;
    }

    public String toString() {
        return "[Activation rule=" + this.rtn.getRule().getName() + ", act#=" + this.activationNumber + ", salience=" + this.salience + ", tuple=" + this.tuple + "]";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!AgendaItemImpl.class.isAssignableFrom(object.getClass())) {
            return false;
        }
        AgendaItem otherItem = (AgendaItem)object;
        return this.rtn.getRule().equals(otherItem.getRule()) && this.tuple.equals(otherItem.getTuple());
    }

    public int hashCode() {
        return this.tuple.hashCode();
    }

    @Override
    public void setQueueIndex(int index) {
        this.index = index;
    }

    @Override
    public void dequeue() {
        if (this.agendaGroup != null) {
            this.agendaGroup.remove(this);
        }
        this.queued = false;
    }

    @Override
    public int getQueueIndex() {
        return this.index;
    }

    @Override
    public void remove() {
        this.dequeue();
    }

    @Override
    public ActivationGroupNode getActivationGroupNode() {
        return this.activationGroupNode;
    }

    @Override
    public void setActivationGroupNode(ActivationGroupNode activationNode) {
        this.activationGroupNode = activationNode;
    }

    @Override
    public InternalAgendaGroup getAgendaGroup() {
        return this.agendaGroup;
    }

    @Override
    public ActivationNode getActivationNode() {
        return this.activationNode;
    }

    @Override
    public void setActivationNode(ActivationNode activationNode) {
        this.activationNode = activationNode;
    }

    @Override
    public GroupElement getSubRule() {
        return this.rtn.getSubRule();
    }

    @Override
    public TerminalNode getTerminalNode() {
        return this.rtn;
    }

    @Override
    public List<FactHandle> getFactHandles() {
        return this.getFactHandles(this.tuple);
    }

    @Override
    public String toExternalForm() {
        return "[ " + this.getRule().getName() + " active=" + this.queued + " ]";
    }

    public List<Object> getObjects() {
        return this.getObjects(this.tuple);
    }

    @Override
    public List<Object> getObjectsDeep() {
        return this.getObjectsDeep((LeftTuple)this.tuple);
    }

    public Object getDeclarationValue(String variableName) {
        Declaration decl = this.rtn.getSubRule().getOuterDeclarations().get(variableName);
        return decl.getValue(this.tuple);
    }

    public List<String> getDeclarationIds() {
        Declaration[] declArray = ((RuleTerminalNode)this.tuple.getTupleSink()).getAllDeclarations();
        ArrayList<String> declarations = new ArrayList<String>();
        for (Declaration decl : declArray) {
            declarations.add(decl.getIdentifier());
        }
        return Collections.unmodifiableList(declarations);
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public boolean isMatched() {
        return this.matched;
    }

    @Override
    public void setMatched(boolean matched) {
        this.matched = matched;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isRuleAgendaItem() {
        return false;
    }

    public boolean isRuleInUse() {
        return this.rtn.getLeftTupleSource() != null;
    }

    @Override
    public Runnable getCallback() {
        return this.callback;
    }

    @Override
    public void setCallback(Runnable callback) {
        this.callback = callback;
    }
}

