/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.facttemplates.Fact;
import org.drools.core.reteoo.Tuple;
import org.drools.core.rule.ConditionalElement;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.PatternSource;
import org.drools.core.rule.accessor.DataProvider;
import org.drools.core.rule.accessor.Wireable;
import org.kie.internal.security.KiePolicyHelper;

public class From
extends ConditionalElement
implements Externalizable,
Wireable,
PatternSource {
    private static final long serialVersionUID = 510L;
    private DataProvider dataProvider;
    private Pattern resultPattern;
    private Class<?> resultClass;

    public From() {
    }

    public From(DataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.dataProvider = (DataProvider)in.readObject();
        this.resultPattern = (Pattern)in.readObject();
        this.resultClass = (Class)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.dataProvider);
        out.writeObject(this.resultPattern);
        out.writeObject(this.resultClass);
    }

    public boolean isReactive() {
        return this.dataProvider.isReactive();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof From)) {
            return false;
        }
        return this.dataProvider.equals(((From)obj).dataProvider);
    }

    public int hashCode() {
        return this.dataProvider.hashCode();
    }

    @Override
    public void wire(Object object) {
        this.dataProvider = KiePolicyHelper.isPolicyEnabled() ? new SafeDataProvider((DataProvider)object) : (DataProvider)object;
    }

    public DataProvider getDataProvider() {
        return this.dataProvider;
    }

    @Override
    public From clone() {
        return new From(this.dataProvider.clone());
    }

    public Map getInnerDeclarations() {
        return Collections.EMPTY_MAP;
    }

    public Map getOuterDeclarations() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public Declaration resolveDeclaration(String identifier) {
        return null;
    }

    public List getNestedElements() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean isPatternScopeDelimiter() {
        return true;
    }

    public void setResultPattern(Pattern pattern) {
        this.resultPattern = pattern;
    }

    public Pattern getResultPattern() {
        return this.resultPattern;
    }

    public Class<?> getResultClass() {
        return this.resultClass != null ? this.resultClass : (this.resultPattern.getObjectType().isTemplate() ? Fact.class : ((ClassObjectType)this.resultPattern.getObjectType()).getClassType());
    }

    public void setResultClass(Class<?> resultClass) {
        this.resultClass = resultClass;
    }

    @Override
    public boolean requiresLeftActivation() {
        return true;
    }

    private static class SafeDataProvider
    implements DataProvider,
    Serializable {
        private static final long serialVersionUID = -1539933583656828737L;
        private DataProvider delegate;

        public SafeDataProvider(DataProvider delegate) {
            this.delegate = delegate;
        }

        @Override
        public Declaration[] getRequiredDeclarations() {
            return this.delegate.getRequiredDeclarations();
        }

        @Override
        public Object createContext() {
            return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return delegate.createContext();
                }
            }, KiePolicyHelper.getAccessContext());
        }

        @Override
        public Iterator getResults(final Tuple tuple, final ReteEvaluator reteEvaluator, final PropagationContext ctx, final Object providerContext) {
            return AccessController.doPrivileged(new PrivilegedAction<Iterator>(){

                @Override
                public Iterator run() {
                    return delegate.getResults(tuple, reteEvaluator, ctx, providerContext);
                }
            }, KiePolicyHelper.getAccessContext());
        }

        @Override
        public void replaceDeclaration(Declaration declaration, Declaration resolved) {
            this.delegate.replaceDeclaration(declaration, resolved);
        }

        @Override
        public SafeDataProvider clone() {
            return new SafeDataProvider(this.delegate.clone());
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        @Override
        public boolean isReactive() {
            return this.delegate.isReactive();
        }
    }
}

